/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.watchface.editor;

import android.os.IBinder;
import androidx.annotation.RestrictTo;
import androidx.wear.watchface.IndentingPrintWriter;
import androidx.wear.watchface.editor.EditorService;
import androidx.wear.watchface.editor.IEditorObserver;
import androidx.wear.watchface.editor.IEditorService;
import androidx.wear.watchface.editor.data.EditorStateWireFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0015\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\b\u0010\u0015\u001a\u00020\u0005H\u0016J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\fH\u0016J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0005H\u0016R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Landroidx/wear/watchface/editor/EditorService;", "Landroidx/wear/watchface/editor/IEditorService$Stub;", "()V", "deathObservers", "Ljava/util/HashMap;", "", "Landroid/os/IBinder$DeathRecipient;", "Lkotlin/collections/HashMap;", "lock", "", "nextId", "observers", "Landroidx/wear/watchface/editor/IEditorObserver;", "broadcastEditorState", "", "editorState", "Landroidx/wear/watchface/editor/data/EditorStateWireFormat;", "dump", "writer", "Landroidx/wear/watchface/IndentingPrintWriter;", "dump$wear_watchface_release", "getApiVersion", "registerObserver", "observer", "unregisterObserver", "observerId", "Companion", "wear-watchface_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class EditorService
extends IEditorService.Stub {
    private final Object lock = new Object();
    private int nextId;
    private final HashMap<Integer, IEditorObserver> observers = new HashMap();
    private final HashMap<Integer, IBinder.DeathRecipient> deathObservers = new HashMap();
    @NotNull
    private static final Lazy globalEditorService$delegate;
    @NotNull
    public static final Companion Companion;

    public int getApiVersion() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerObserver(@NotNull IEditorObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            int n = this.nextId;
            this.nextId = n + 1;
            int id = n;
            ((Map)this.observers).put(id, observer);
            IBinder.DeathRecipient deathObserver = new IBinder.DeathRecipient(id, this, observer){
                final /* synthetic */ int $id;
                final /* synthetic */ EditorService this$0;
                final /* synthetic */ IEditorObserver $observer$inlined;
                {
                    this.$id = n;
                    this.this$0 = editorService;
                    this.$observer$inlined = iEditorObserver;
                }

                public final void binderDied() {
                    this.this$0.unregisterObserver(this.$id);
                }
            };
            observer.asBinder().linkToDeath(deathObserver, 0);
            ((Map)this.deathObservers).put(id, deathObserver);
            int n2 = id;
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterObserver(int observerId) {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            IBinder.DeathRecipient deathRecipient = this.deathObservers.get(observerId);
            if (deathRecipient != null) {
                IBinder.DeathRecipient deathRecipient2 = deathRecipient;
                boolean bl4 = false;
                boolean bl5 = false;
                IBinder.DeathRecipient it = deathRecipient2;
                boolean bl6 = false;
                IEditorObserver iEditorObserver = this.observers.get(observerId);
                if (iEditorObserver != null && (iEditorObserver = iEditorObserver.asBinder()) != null) {
                    iEditorObserver.unlinkToDeath(it, 0);
                }
            }
            this.observers.remove(observerId);
            IBinder.DeathRecipient deathRecipient3 = this.deathObservers.remove(observerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void broadcastEditorState(@NotNull EditorStateWireFormat editorState) {
        Intrinsics.checkNotNullParameter((Object)editorState, (String)"editorState");
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            Map map = this.observers;
            boolean bl4 = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                boolean bl5 = false;
                IEditorObserver observer = (IEditorObserver)entry2.getValue();
                IBinder iBinder = observer.asBinder();
                Intrinsics.checkNotNullExpressionValue((Object)iBinder, (String)"observer.asBinder()");
                if (!iBinder.isBinderAlive()) continue;
                observer.onEditorStateChange(editorState);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void dump$wear_watchface_release(@NotNull IndentingPrintWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.println("EditorService:");
        writer.increaseIndent();
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            Map map = this.observers;
            boolean bl4 = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                void id;
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                boolean bl5 = false;
                int n = ((Number)entry2.getKey()).intValue();
                entry2 = entry;
                bl5 = false;
                IEditorObserver observer = (IEditorObserver)entry2.getValue();
                StringBuilder stringBuilder = new StringBuilder().append("id = ").append((int)id).append(", alive = ");
                IBinder iBinder = observer.asBinder();
                Intrinsics.checkNotNullExpressionValue((Object)iBinder, (String)"observer.asBinder()");
                writer.println(stringBuilder.append(iBinder.isBinderAlive()).toString());
                IBinder iBinder2 = observer.asBinder();
                Intrinsics.checkNotNullExpressionValue((Object)iBinder2, (String)"observer.asBinder()");
                if (!iBinder2.isBinderAlive()) continue;
                writer.println(this.getApiVersion() + " = {observer.apiVersion}");
            }
            Unit unit = Unit.INSTANCE;
        }
        writer.decreaseIndent();
    }

    static {
        Companion = new Companion(null);
        globalEditorService$delegate = LazyKt.lazy((Function0)Companion.globalEditorService.2.INSTANCE);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Landroidx/wear/watchface/editor/EditorService$Companion;", "", "()V", "globalEditorService", "Landroidx/wear/watchface/editor/EditorService;", "getGlobalEditorService", "()Landroidx/wear/watchface/editor/EditorService;", "globalEditorService$delegate", "Lkotlin/Lazy;", "wear-watchface_release"})
    public static final class Companion {
        @NotNull
        public final EditorService getGlobalEditorService() {
            Lazy lazy = globalEditorService$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (EditorService)((Object)lazy.getValue());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

