/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.core.layout;

import androidx.window.core.ExperimentalWindowCoreApi;
import androidx.window.core.layout.WindowHeightSizeClass;
import androidx.window.core.layout.WindowWidthSizeClass;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Landroidx/window/core/layout/WindowSizeClass;", "", "widthDp", "", "heightDp", "(II)V", "getHeightDp", "()I", "getWidthDp", "windowHeightSizeClass", "Landroidx/window/core/layout/WindowHeightSizeClass;", "getWindowHeightSizeClass", "()Landroidx/window/core/layout/WindowHeightSizeClass;", "windowWidthSizeClass", "Landroidx/window/core/layout/WindowWidthSizeClass;", "getWindowWidthSizeClass", "()Landroidx/window/core/layout/WindowWidthSizeClass;", "equals", "", "other", "hashCode", "toString", "", "Companion", "window-core"})
@SourceDebugExtension(value={"SMAP\nWindowSizeClass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowSizeClass.kt\nandroidx/window/core/layout/WindowSizeClass\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1#2:150\n*E\n"})
public final class WindowSizeClass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int widthDp;
    private final int heightDp;

    public WindowSizeClass(int widthDp, int heightDp) {
        this.widthDp = widthDp;
        this.heightDp = heightDp;
        if (!(this.widthDp >= 0)) {
            boolean $i$a$-require-WindowSizeClass$32 = false;
            String $i$a$-require-WindowSizeClass$32 = "Must have non-negative widthDp: " + this.widthDp + '.';
            throw new IllegalArgumentException($i$a$-require-WindowSizeClass$32.toString());
        }
        if (!(this.heightDp >= 0)) {
            boolean bl = false;
            String string = "Must have non-negative heightDp: " + this.heightDp + '.';
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final int getWidthDp() {
        return this.widthDp;
    }

    public final int getHeightDp() {
        return this.heightDp;
    }

    @NotNull
    public final WindowWidthSizeClass getWindowWidthSizeClass() {
        return WindowWidthSizeClass.Companion.compute$window_core(this.widthDp);
    }

    @NotNull
    public final WindowHeightSizeClass getWindowHeightSizeClass() {
        return WindowHeightSizeClass.Companion.compute$window_core(this.heightDp);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type androidx.window.core.layout.WindowSizeClass");
        WindowSizeClass cfr_ignored_0 = (WindowSizeClass)other;
        if (this.widthDp != ((WindowSizeClass)other).widthDp) {
            return false;
        }
        return this.heightDp == ((WindowSizeClass)other).heightDp;
    }

    public int hashCode() {
        int result = Integer.hashCode(this.widthDp);
        result = 31 * result + Integer.hashCode(this.heightDp);
        return result;
    }

    @NotNull
    public String toString() {
        return "SizeClass { widthDp: " + this.widthDp + ", heightDp: " + this.heightDp + " }";
    }

    @JvmStatic
    @NotNull
    public static final WindowSizeClass compute(float dpWidth, float dpHeight) {
        return Companion.compute(dpWidth, dpHeight);
    }

    @JvmStatic
    @ExperimentalWindowCoreApi
    @NotNull
    public static final WindowSizeClass compute(int widthPx, int heightPx, float density) {
        return Companion.compute(widthPx, heightPx, density);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0006H\u0007\u00a8\u0006\f"}, d2={"Landroidx/window/core/layout/WindowSizeClass$Companion;", "", "()V", "compute", "Landroidx/window/core/layout/WindowSizeClass;", "dpWidth", "", "dpHeight", "widthPx", "", "heightPx", "density", "window-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final WindowSizeClass compute(float dpWidth, float dpHeight) {
            int widthDp = dpWidth < 600.0f ? 0 : (dpWidth < 840.0f ? 600 : 840);
            int heightDp = dpHeight < 480.0f ? 0 : (dpHeight < 900.0f ? 480 : 900);
            return new WindowSizeClass(widthDp, heightDp);
        }

        @JvmStatic
        @ExperimentalWindowCoreApi
        @NotNull
        public final WindowSizeClass compute(int widthPx, int heightPx, float density) {
            float widthDp = (float)widthPx / density;
            float heightDp = (float)heightPx / density;
            return this.compute(widthDp, heightDp);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

