/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.core.layout;

import androidx.window.core.ExperimentalWindowCoreApi;
import androidx.window.core.layout.WindowSizeClass;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001H\u0007\u001a\u0014\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0001H\u0007\u001a\u0014\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\b\u001a\u00020\u0001H\u0007\u00a8\u0006\t"}, d2={"scoreWithinAreaBounds", "", "Landroidx/window/core/layout/WindowSizeClass;", "windowWidthDp", "windowHeightDp", "scoreWithinHeightDp", "heightDp", "scoreWithinWidthDp", "widthDp", "window-core"})
@JvmName(name="WindowSizeClassScoreCalculator")
public final class WindowSizeClassScoreCalculator {
    @ExperimentalWindowCoreApi
    public static final int scoreWithinWidthDp(@NotNull WindowSizeClass $this$scoreWithinWidthDp, int widthDp) {
        Intrinsics.checkNotNullParameter((Object)$this$scoreWithinWidthDp, (String)"<this>");
        return $this$scoreWithinWidthDp.getWidthDp() <= widthDp ? Integer.MAX_VALUE / (1 + widthDp - $this$scoreWithinWidthDp.getWidthDp()) : -1;
    }

    @ExperimentalWindowCoreApi
    public static final int scoreWithinHeightDp(@NotNull WindowSizeClass $this$scoreWithinHeightDp, int heightDp) {
        Intrinsics.checkNotNullParameter((Object)$this$scoreWithinHeightDp, (String)"<this>");
        return $this$scoreWithinHeightDp.getHeightDp() <= heightDp ? Integer.MAX_VALUE / (1 + heightDp - $this$scoreWithinHeightDp.getHeightDp()) : -1;
    }

    @ExperimentalWindowCoreApi
    public static final int scoreWithinAreaBounds(@NotNull WindowSizeClass $this$scoreWithinAreaBounds, int windowWidthDp, int windowHeightDp) {
        Intrinsics.checkNotNullParameter((Object)$this$scoreWithinAreaBounds, (String)"<this>");
        if (windowWidthDp < $this$scoreWithinAreaBounds.getWidthDp() || windowHeightDp < $this$scoreWithinAreaBounds.getHeightDp()) {
            return -1;
        }
        int areaDifference = windowWidthDp * windowHeightDp - $this$scoreWithinAreaBounds.getWidthDp() * $this$scoreWithinAreaBounds.getHeightDp();
        return Integer.MAX_VALUE / (1 + areaDifference);
    }
}

