/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.java.area;

import android.app.Activity;
import androidx.core.util.Consumer;
import androidx.window.area.WindowAreaController;
import androidx.window.area.WindowAreaSessionCallback;
import androidx.window.area.WindowAreaStatus;
import androidx.window.core.ExperimentalWindowApi;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.ExecutorsKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006J!\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0096\u0001J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0016H\u0096\u0001J\u0014\u0010\u0017\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006J\u001e\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014R\u001e\u0010\u0004\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Landroidx/window/java/area/WindowAreaControllerJavaAdapter;", "Landroidx/window/area/WindowAreaController;", "controller", "(Landroidx/window/area/WindowAreaController;)V", "consumerToJobMap", "", "Landroidx/core/util/Consumer;", "Lkotlinx/coroutines/Job;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "addRearDisplayStatusListener", "", "executor", "Ljava/util/concurrent/Executor;", "consumer", "Landroidx/window/area/WindowAreaStatus;", "rearDisplayMode", "activity", "Landroid/app/Activity;", "windowAreaSessionCallback", "Landroidx/window/area/WindowAreaSessionCallback;", "rearDisplayStatus", "Lkotlinx/coroutines/flow/Flow;", "removeRearDisplayStatusListener", "startRearDisplayModeSession", "window-java_release"})
@ExperimentalWindowApi
public final class WindowAreaControllerJavaAdapter
implements WindowAreaController {
    @NotNull
    private final WindowAreaController controller;
    @NotNull
    private final ReentrantLock lock;
    @NotNull
    private final Map<Consumer<?>, Job> consumerToJobMap;

    public WindowAreaControllerJavaAdapter(@NotNull WindowAreaController controller) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        this.controller = controller;
        this.lock = new ReentrantLock();
        this.consumerToJobMap = new LinkedHashMap();
    }

    public void rearDisplayMode(@NotNull Activity activity, @NotNull Executor executor, @NotNull WindowAreaSessionCallback windowAreaSessionCallback) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)windowAreaSessionCallback, (String)"windowAreaSessionCallback");
        this.controller.rearDisplayMode(activity, executor, windowAreaSessionCallback);
    }

    @NotNull
    public Flow<WindowAreaStatus> rearDisplayStatus() {
        return this.controller.rearDisplayStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addRearDisplayStatusListener(@NotNull Executor executor, @NotNull Consumer<WindowAreaStatus> consumer) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Flow statusFlow = this.controller.rearDisplayStatus();
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.consumerToJobMap.get(consumer) == null) {
                CoroutineScope scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)ExecutorsKt.from((Executor)executor)));
                this.consumerToJobMap.put(consumer, BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Flow<WindowAreaStatus>)statusFlow, consumer, null){
                    int label;
                    final /* synthetic */ Flow<WindowAreaStatus> $statusFlow;
                    final /* synthetic */ Consumer<WindowAreaStatus> $consumer;
                    {
                        this.$statusFlow = $statusFlow;
                        this.$consumer = $consumer;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = this.$statusFlow.collect(new FlowCollector(this.$consumer){
                                    final /* synthetic */ Consumer<WindowAreaStatus> $consumer;
                                    {
                                        this.$consumer = $consumer;
                                    }

                                    @Nullable
                                    public final Object emit(@NotNull WindowAreaStatus it, @NotNull Continuation<? super Unit> $completion) {
                                        this.$consumer.accept((Object)it);
                                        return Unit.INSTANCE;
                                    }
                                }, (Continuation)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null));
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeRearDisplayStatusListener(@NotNull Consumer<WindowAreaStatus> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            Job job = this.consumerToJobMap.get(consumer);
            if (job != null) {
                Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
            }
            Job job2 = this.consumerToJobMap.remove(consumer);
        }
        finally {
            lock.unlock();
        }
    }

    public final void startRearDisplayModeSession(@NotNull Activity activity, @NotNull Executor executor, @NotNull WindowAreaSessionCallback windowAreaSessionCallback) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)windowAreaSessionCallback, (String)"windowAreaSessionCallback");
        this.controller.rearDisplayMode(activity, executor, windowAreaSessionCallback);
    }
}

