/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.java.embedding;

import android.app.Activity;
import androidx.core.util.Consumer;
import androidx.window.RequiresWindowSdkExtension;
import androidx.window.embedding.ActivityEmbeddingController;
import androidx.window.embedding.EmbeddedActivityWindowInfo;
import androidx.window.java.core.CallbackToFlowAdapter;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0007J\u0016\u0010\u0010\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Landroidx/window/java/embedding/ActivityEmbeddingControllerCallbackAdapter;", "", "controller", "Landroidx/window/embedding/ActivityEmbeddingController;", "(Landroidx/window/embedding/ActivityEmbeddingController;)V", "callbackToFlowAdapter", "Landroidx/window/java/core/CallbackToFlowAdapter;", "addEmbeddedActivityWindowInfoListener", "", "activity", "Landroid/app/Activity;", "executor", "Ljava/util/concurrent/Executor;", "listener", "Landroidx/core/util/Consumer;", "Landroidx/window/embedding/EmbeddedActivityWindowInfo;", "removeEmbeddedActivityWindowInfoListener", "window-java_release"})
public final class ActivityEmbeddingControllerCallbackAdapter {
    @NotNull
    private final ActivityEmbeddingController controller;
    @NotNull
    private final CallbackToFlowAdapter callbackToFlowAdapter;

    public ActivityEmbeddingControllerCallbackAdapter(@NotNull ActivityEmbeddingController controller) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        this.controller = controller;
        this.callbackToFlowAdapter = new CallbackToFlowAdapter();
    }

    @RequiresWindowSdkExtension(version=6)
    public final void addEmbeddedActivityWindowInfoListener(@NotNull Activity activity, @NotNull Executor executor, @NotNull Consumer<EmbeddedActivityWindowInfo> listener) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.callbackToFlowAdapter.connect(executor, listener, this.controller.embeddedActivityWindowInfo(activity));
    }

    @RequiresWindowSdkExtension(version=6)
    public final void removeEmbeddedActivityWindowInfoListener(@NotNull Consumer<EmbeddedActivityWindowInfo> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.callbackToFlowAdapter.disconnect(listener);
    }
}

