/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.java.embedding;

import androidx.core.util.Consumer;
import androidx.window.RequiresWindowSdkExtension;
import androidx.window.embedding.OverlayController;
import androidx.window.embedding.OverlayInfo;
import androidx.window.java.core.CallbackToFlowAdapter;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0007J\u0016\u0010\u0010\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Landroidx/window/java/embedding/OverlayControllerCallbackAdapter;", "", "controller", "Landroidx/window/embedding/OverlayController;", "(Landroidx/window/embedding/OverlayController;)V", "callbackToFlowAdapter", "Landroidx/window/java/core/CallbackToFlowAdapter;", "addOverlayInfoListener", "", "overlayTag", "", "executor", "Ljava/util/concurrent/Executor;", "consumer", "Landroidx/core/util/Consumer;", "Landroidx/window/embedding/OverlayInfo;", "removeOverlayInfoListener", "window-java_release"})
public final class OverlayControllerCallbackAdapter {
    @NotNull
    private final OverlayController controller;
    @NotNull
    private final CallbackToFlowAdapter callbackToFlowAdapter;

    public OverlayControllerCallbackAdapter(@NotNull OverlayController controller) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        this.controller = controller;
        this.callbackToFlowAdapter = new CallbackToFlowAdapter();
    }

    @RequiresWindowSdkExtension(version=5)
    public final void addOverlayInfoListener(@NotNull String overlayTag, @NotNull Executor executor, @NotNull Consumer<OverlayInfo> consumer) {
        Intrinsics.checkNotNullParameter((Object)overlayTag, (String)"overlayTag");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.callbackToFlowAdapter.connect(executor, consumer, this.controller.overlayInfo(overlayTag));
    }

    @RequiresWindowSdkExtension(version=5)
    public final void removeOverlayInfoListener(@NotNull Consumer<OverlayInfo> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.callbackToFlowAdapter.disconnect(consumer);
    }
}

