/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.testing.layout;

import android.graphics.Rect;
import androidx.window.layout.FoldingFeature;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\u0016\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001d"}, d2={"Landroidx/window/testing/layout/FakeFoldingFeature;", "Landroidx/window/layout/FoldingFeature;", "bounds", "Landroid/graphics/Rect;", "isSeparating", "", "occlusionType", "Landroidx/window/layout/FoldingFeature$OcclusionType;", "orientation", "Landroidx/window/layout/FoldingFeature$Orientation;", "state", "Landroidx/window/layout/FoldingFeature$State;", "(Landroid/graphics/Rect;ZLandroidx/window/layout/FoldingFeature$OcclusionType;Landroidx/window/layout/FoldingFeature$Orientation;Landroidx/window/layout/FoldingFeature$State;)V", "getBounds", "()Landroid/graphics/Rect;", "()Z", "getOcclusionType", "()Landroidx/window/layout/FoldingFeature$OcclusionType;", "getOrientation", "()Landroidx/window/layout/FoldingFeature$Orientation;", "getState", "()Landroidx/window/layout/FoldingFeature$State;", "equals", "other", "", "hashCode", "", "toString", "", "window-testing_release"})
@SourceDebugExtension(value={"SMAP\nDisplayFeatureTesting.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisplayFeatureTesting.kt\nandroidx/window/testing/layout/FakeFoldingFeature\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,217:1\n1#2:218\n*E\n"})
final class FakeFoldingFeature
implements FoldingFeature {
    @NotNull
    private final Rect bounds;
    private final boolean isSeparating;
    @NotNull
    private final FoldingFeature.OcclusionType occlusionType;
    @NotNull
    private final FoldingFeature.Orientation orientation;
    @NotNull
    private final FoldingFeature.State state;

    public FakeFoldingFeature(@NotNull Rect bounds, boolean isSeparating, @NotNull FoldingFeature.OcclusionType occlusionType, @NotNull FoldingFeature.Orientation orientation, @NotNull FoldingFeature.State state) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)occlusionType, (String)"occlusionType");
        Intrinsics.checkNotNullParameter((Object)orientation, (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.bounds = bounds;
        this.isSeparating = isSeparating;
        this.occlusionType = occlusionType;
        this.orientation = orientation;
        this.state = state;
        if (!(this.getBounds().width() != 0 || this.getBounds().height() != 0)) {
            boolean $i$a$-require-FakeFoldingFeature$32 = false;
            String $i$a$-require-FakeFoldingFeature$32 = "Bounds must be non zero";
            throw new IllegalArgumentException($i$a$-require-FakeFoldingFeature$32.toString());
        }
        if (!(this.getBounds().left == 0 || this.getBounds().top == 0)) {
            boolean bl = false;
            String string = "Bounding rectangle must start at the top or left window edge for folding features";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public Rect getBounds() {
        return this.bounds;
    }

    public boolean isSeparating() {
        return this.isSeparating;
    }

    @NotNull
    public FoldingFeature.OcclusionType getOcclusionType() {
        return this.occlusionType;
    }

    @NotNull
    public FoldingFeature.Orientation getOrientation() {
        return this.orientation;
    }

    @NotNull
    public FoldingFeature.State getState() {
        return this.state;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type androidx.window.testing.layout.FakeFoldingFeature");
        FakeFoldingFeature cfr_ignored_0 = (FakeFoldingFeature)other;
        if (!Intrinsics.areEqual((Object)this.getBounds(), (Object)((FakeFoldingFeature)other).getBounds())) {
            return false;
        }
        if (this.isSeparating() != ((FakeFoldingFeature)other).isSeparating()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getOcclusionType(), (Object)((FakeFoldingFeature)other).getOcclusionType())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getOrientation(), (Object)((FakeFoldingFeature)other).getOrientation())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getState(), (Object)((FakeFoldingFeature)other).getState());
    }

    public int hashCode() {
        int result = this.getBounds().hashCode();
        result = 31 * result + Boolean.hashCode(this.isSeparating());
        result = 31 * result + this.getOcclusionType().hashCode();
        result = 31 * result + this.getOrientation().hashCode();
        result = 31 * result + this.getState().hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return FakeFoldingFeature.class.getSimpleName() + " { bounds = " + this.getBounds() + ", isSeparating = " + this.isSeparating() + ", occlusionType = " + this.getOcclusionType() + ", orientation = " + this.getOrientation() + ", state = " + this.getState();
    }
}

