/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.testing.layout;

import android.app.Activity;
import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.RequiresApi;
import androidx.window.layout.WindowMetrics;
import androidx.window.layout.WindowMetricsCalculator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Landroidx/window/testing/layout/StubWindowMetricsCalculator;", "Landroidx/window/layout/WindowMetricsCalculator;", "()V", "computeCurrentWindowMetrics", "Landroidx/window/layout/WindowMetrics;", "activity", "Landroid/app/Activity;", "context", "Landroid/content/Context;", "computeMaximumWindowMetrics", "Api17Impl", "Api30Impl", "window-testing_release"})
public final class StubWindowMetricsCalculator
implements WindowMetricsCalculator {
    @NotNull
    public WindowMetrics computeCurrentWindowMetrics(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        DisplayMetrics displayMetrics = activity.getResources().getDisplayMetrics();
        Rect bounds = new Rect(0, 0, displayMetrics.widthPixels, displayMetrics.heightPixels);
        return new WindowMetrics(bounds, null, 2, null);
    }

    @NotNull
    public WindowMetrics computeMaximumWindowMetrics(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        DisplayMetrics displayMetrics = activity.getResources().getDisplayMetrics();
        Rect bounds = new Rect(0, 0, displayMetrics.widthPixels, displayMetrics.heightPixels);
        return new WindowMetrics(bounds, null, 2, null);
    }

    @NotNull
    public WindowMetrics computeCurrentWindowMetrics(@NotNull Context context) {
        WindowMetrics windowMetrics;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("window");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.WindowManager");
        WindowManager wm = (WindowManager)object;
        if (Build.VERSION.SDK_INT >= 30) {
            windowMetrics = Api30Impl.INSTANCE.getWindowMetrics(wm);
        } else if (Build.VERSION.SDK_INT >= 17) {
            Point displaySize = new Point();
            Display display = wm.getDefaultDisplay();
            Intrinsics.checkNotNullExpressionValue((Object)display, (String)"wm.defaultDisplay");
            Api17Impl.INSTANCE.getRealSize(display, displaySize);
            Rect bounds = new Rect(0, 0, displaySize.x, displaySize.y);
            windowMetrics = new WindowMetrics(bounds, null, 2, null);
        } else {
            int width = wm.getDefaultDisplay().getWidth();
            int height = wm.getDefaultDisplay().getHeight();
            Rect bounds = new Rect(0, 0, width, height);
            windowMetrics = new WindowMetrics(bounds, null, 2, null);
        }
        return windowMetrics;
    }

    @NotNull
    public WindowMetrics computeMaximumWindowMetrics(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.computeCurrentWindowMetrics(context);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c3\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Landroidx/window/testing/layout/StubWindowMetricsCalculator$Api17Impl;", "", "()V", "getRealSize", "", "display", "Landroid/view/Display;", "point", "Landroid/graphics/Point;", "window-testing_release"})
    @RequiresApi(value=17)
    private static final class Api17Impl {
        @NotNull
        public static final Api17Impl INSTANCE = new Api17Impl();

        private Api17Impl() {
        }

        public final void getRealSize(@NotNull Display display, @NotNull Point point) {
            Intrinsics.checkNotNullParameter((Object)display, (String)"display");
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            display.getRealSize(point);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c3\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/window/testing/layout/StubWindowMetricsCalculator$Api30Impl;", "", "()V", "getWindowMetrics", "Landroidx/window/layout/WindowMetrics;", "windowManager", "Landroid/view/WindowManager;", "window-testing_release"})
    @RequiresApi(value=30)
    private static final class Api30Impl {
        @NotNull
        public static final Api30Impl INSTANCE = new Api30Impl();

        private Api30Impl() {
        }

        @NotNull
        public final WindowMetrics getWindowMetrics(@NotNull WindowManager windowManager) {
            Intrinsics.checkNotNullParameter((Object)windowManager, (String)"windowManager");
            Rect rect = windowManager.getCurrentWindowMetrics().getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"windowManager.currentWindowMetrics.bounds");
            return new WindowMetrics(rect, null, 2, null);
        }
    }
}

