/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.testing.layout;

import android.app.Activity;
import android.graphics.Rect;
import androidx.annotation.IntRange;
import androidx.window.layout.FoldingFeature;
import androidx.window.layout.WindowMetricsCalculator;
import androidx.window.testing.layout.FakeFoldingFeature;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a=\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007\u00a2\u0006\u0002\b\u000b\u001a=\u0010\u0000\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\b\b\u0003\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007\u00a2\u0006\u0002\b\u000b\u001a8\u0010\u000e\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000f"}, d2={"FoldingFeature", "Landroidx/window/layout/FoldingFeature;", "activity", "Landroid/app/Activity;", "center", "", "size", "state", "Landroidx/window/layout/FoldingFeature$State;", "orientation", "Landroidx/window/layout/FoldingFeature$Orientation;", "createFoldingFeature", "windowBounds", "Landroid/graphics/Rect;", "foldingFeatureInternal", "window-testing_release"})
@JvmName(name="DisplayFeatureTesting")
public final class DisplayFeatureTesting {
    @JvmOverloads
    @JvmName(name="createFoldingFeature")
    @NotNull
    public static final FoldingFeature createFoldingFeature(@NotNull Activity activity, @IntRange(from=-1L) int center, int size, @NotNull FoldingFeature.State state, @NotNull FoldingFeature.Orientation orientation) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)orientation, (String)"orientation");
        WindowMetricsCalculator metricsCalculator = WindowMetricsCalculator.Companion.getOrCreate();
        Rect windowBounds = metricsCalculator.computeCurrentWindowMetrics(activity).getBounds();
        return DisplayFeatureTesting.foldingFeatureInternal(windowBounds, center, size, state, orientation);
    }

    public static /* synthetic */ FoldingFeature createFoldingFeature$default(Activity activity, int n, int n2, FoldingFeature.State state, FoldingFeature.Orientation orientation, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = -1;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        if ((n3 & 8) != 0) {
            state = FoldingFeature.State.HALF_OPENED;
        }
        if ((n3 & 0x10) != 0) {
            orientation = FoldingFeature.Orientation.HORIZONTAL;
        }
        return DisplayFeatureTesting.createFoldingFeature(activity, n, n2, state, orientation);
    }

    @JvmOverloads
    @JvmName(name="createFoldingFeature")
    @NotNull
    public static final FoldingFeature createFoldingFeature(@NotNull Rect windowBounds, @IntRange(from=-1L) int center, int size, @NotNull FoldingFeature.State state, @NotNull FoldingFeature.Orientation orientation) {
        Intrinsics.checkNotNullParameter((Object)windowBounds, (String)"windowBounds");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)orientation, (String)"orientation");
        return DisplayFeatureTesting.foldingFeatureInternal(windowBounds, center, size, state, orientation);
    }

    public static /* synthetic */ FoldingFeature createFoldingFeature$default(Rect rect, int n, int n2, FoldingFeature.State state, FoldingFeature.Orientation orientation, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = -1;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        if ((n3 & 8) != 0) {
            state = FoldingFeature.State.HALF_OPENED;
        }
        if ((n3 & 0x10) != 0) {
            orientation = FoldingFeature.Orientation.HORIZONTAL;
        }
        return DisplayFeatureTesting.createFoldingFeature(rect, n, n2, state, orientation);
    }

    private static final FoldingFeature foldingFeatureInternal(Rect windowBounds, int center, int size, FoldingFeature.State state, FoldingFeature.Orientation orientation) {
        Rect rect;
        FoldingFeature.Orientation orientation2;
        boolean shouldTreatAsHinge = size != 0;
        boolean isSeparating = shouldTreatAsHinge || Intrinsics.areEqual((Object)state, (Object)FoldingFeature.State.HALF_OPENED);
        int offset = size / 2;
        int actualCenter = center < 0 ? (Intrinsics.areEqual((Object)(orientation2 = orientation), (Object)FoldingFeature.Orientation.HORIZONTAL) ? windowBounds.centerY() : (Intrinsics.areEqual((Object)orientation2, (Object)FoldingFeature.Orientation.VERTICAL) ? windowBounds.centerX() : windowBounds.centerX())) : center;
        int start = actualCenter - offset;
        int end = actualCenter + offset;
        if (Intrinsics.areEqual((Object)orientation, (Object)FoldingFeature.Orientation.VERTICAL)) {
            int windowHeight = windowBounds.height();
            rect = new Rect(start, 0, end, windowHeight);
        } else {
            int windowWidth = windowBounds.width();
            rect = new Rect(0, start, windowWidth, end);
        }
        Rect bounds = rect;
        FoldingFeature.OcclusionType occlusionType = shouldTreatAsHinge ? FoldingFeature.OcclusionType.FULL : FoldingFeature.OcclusionType.NONE;
        return new FakeFoldingFeature(bounds, isSeparating, occlusionType, orientation, state);
    }

    static /* synthetic */ FoldingFeature foldingFeatureInternal$default(Rect rect, int n, int n2, FoldingFeature.State state, FoldingFeature.Orientation orientation, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = -1;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        if ((n3 & 8) != 0) {
            state = FoldingFeature.State.HALF_OPENED;
        }
        if ((n3 & 0x10) != 0) {
            orientation = FoldingFeature.Orientation.HORIZONTAL;
        }
        return DisplayFeatureTesting.foldingFeatureInternal(rect, n, n2, state, orientation);
    }

    @JvmOverloads
    @JvmName(name="createFoldingFeature")
    @NotNull
    public static final FoldingFeature createFoldingFeature(@NotNull Activity activity, @IntRange(from=-1L) int center, int size, @NotNull FoldingFeature.State state) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return DisplayFeatureTesting.createFoldingFeature$default(activity, center, size, state, null, 16, null);
    }

    @JvmOverloads
    @JvmName(name="createFoldingFeature")
    @NotNull
    public static final FoldingFeature createFoldingFeature(@NotNull Activity activity, @IntRange(from=-1L) int center, int size) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        return DisplayFeatureTesting.createFoldingFeature$default(activity, center, size, null, null, 24, null);
    }

    @JvmOverloads
    @JvmName(name="createFoldingFeature")
    @NotNull
    public static final FoldingFeature createFoldingFeature(@NotNull Activity activity, @IntRange(from=-1L) int center) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        return DisplayFeatureTesting.createFoldingFeature$default(activity, center, 0, null, null, 28, null);
    }

    @JvmOverloads
    @JvmName(name="createFoldingFeature")
    @NotNull
    public static final FoldingFeature createFoldingFeature(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        return DisplayFeatureTesting.createFoldingFeature$default(activity, 0, 0, null, null, 30, null);
    }

    @JvmOverloads
    @JvmName(name="createFoldingFeature")
    @NotNull
    public static final FoldingFeature createFoldingFeature(@NotNull Rect windowBounds, @IntRange(from=-1L) int center, int size, @NotNull FoldingFeature.State state) {
        Intrinsics.checkNotNullParameter((Object)windowBounds, (String)"windowBounds");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return DisplayFeatureTesting.createFoldingFeature$default(windowBounds, center, size, state, null, 16, null);
    }

    @JvmOverloads
    @JvmName(name="createFoldingFeature")
    @NotNull
    public static final FoldingFeature createFoldingFeature(@NotNull Rect windowBounds, @IntRange(from=-1L) int center, int size) {
        Intrinsics.checkNotNullParameter((Object)windowBounds, (String)"windowBounds");
        return DisplayFeatureTesting.createFoldingFeature$default(windowBounds, center, size, null, null, 24, null);
    }

    @JvmOverloads
    @JvmName(name="createFoldingFeature")
    @NotNull
    public static final FoldingFeature createFoldingFeature(@NotNull Rect windowBounds, @IntRange(from=-1L) int center) {
        Intrinsics.checkNotNullParameter((Object)windowBounds, (String)"windowBounds");
        return DisplayFeatureTesting.createFoldingFeature$default(windowBounds, center, 0, null, null, 28, null);
    }

    @JvmOverloads
    @JvmName(name="createFoldingFeature")
    @NotNull
    public static final FoldingFeature createFoldingFeature(@NotNull Rect windowBounds) {
        Intrinsics.checkNotNullParameter((Object)windowBounds, (String)"windowBounds");
        return DisplayFeatureTesting.createFoldingFeature$default(windowBounds, 0, 0, null, null, 30, null);
    }
}

