/*
 * Decompiled with CFR 0.152.
 */
package app.commerceio.spring.data.search;

import app.commerceio.spring.data.search.SearchOp;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class SearchCriteria {
    private boolean exists;
    private String key;
    private SearchOp op;
    private String value;
    private boolean isArray;
    private Class<?> type;

    public static SearchCriteriaBuilder builder() {
        return new SearchCriteriaBuilder();
    }

    public boolean isExists() {
        return this.exists;
    }

    public String getKey() {
        return this.key;
    }

    public SearchOp getOp() {
        return this.op;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public Class<?> getType() {
        return this.type;
    }

    public SearchCriteria() {
    }

    public SearchCriteria(boolean exists, String key, SearchOp op, String value, boolean isArray, Class<?> type) {
        this.exists = exists;
        this.key = key;
        this.op = op;
        this.value = value;
        this.isArray = isArray;
        this.type = type;
    }

    public static class SearchCriteriaBuilder {
        private static final Pattern BOOLEAN_PATTERN = Pattern.compile("^(false|true)$", 2);
        private boolean exists;
        private String key;
        private SearchOp op;
        private String value;

        SearchCriteriaBuilder() {
        }

        public SearchCriteriaBuilder exists(boolean exists) {
            this.exists = exists;
            return this;
        }

        public SearchCriteriaBuilder key(String key) {
            this.key = key;
            return this;
        }

        public SearchCriteriaBuilder op(SearchOp op) {
            this.op = op;
            return this;
        }

        public SearchCriteriaBuilder value(String value) {
            this.value = value;
            return this;
        }

        public SearchCriteria build() {
            boolean isArray = false;
            Class type = String.class;
            if (this.value != null) {
                this.value = StringUtils.trimToNull((String)this.value.replaceAll("^\"|^'|\"$|'$", "").replace("\\\"", "\"").replace("\\'", "'"));
                String[] values = this.value.split("(?<!\\\\),");
                boolean bl = isArray = values.length > 1;
                if (isArray) {
                    if (Stream.of(values).allMatch(this::isDate)) {
                        type = Instant.class;
                    } else if (Stream.of(values).allMatch(this::isBoolean)) {
                        type = Boolean.class;
                    } else if (Stream.of(values).allMatch(this::isNumber)) {
                        type = Number.class;
                    }
                } else if (this.isDate(this.value)) {
                    type = Instant.class;
                } else if (this.isBoolean(this.value)) {
                    type = Boolean.class;
                } else if (this.isNumber(this.value)) {
                    type = Number.class;
                }
            }
            return new SearchCriteria(this.exists, this.key, this.op, this.value, isArray, type);
        }

        private boolean isNumber(String value) {
            if (value == null) {
                return false;
            }
            try {
                Number number = NumberFormat.getInstance().parse(value);
                return number != null;
            }
            catch (ParseException ignored) {
                return false;
            }
        }

        private boolean isBoolean(String value) {
            if (value == null) {
                return false;
            }
            return BOOLEAN_PATTERN.matcher(value).matches();
        }

        private boolean isDate(String value) {
            if (value == null) {
                return false;
            }
            try {
                Instant instant = OffsetDateTime.parse(value).toInstant();
                return instant != null;
            }
            catch (Exception retry) {
                try {
                    Instant instant = LocalDate.parse(value).atStartOfDay().atOffset(ZoneOffset.UTC).toInstant();
                    return instant != null;
                }
                catch (Exception ignored) {
                    return false;
                }
            }
        }
    }
}

