/*
 * Decompiled with CFR 0.152.
 */
package app.softwork.serialization.csv;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorKt;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalSerializationApi
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u0010H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\tH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0012H\u0016J\n\u0010#\u001a\u0004\u0018\u00010$H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u0004H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006+"}, d2={"Lapp/softwork/serialization/csv/CSVDecoder;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "data", "", "", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "(Ljava/util/List;Lkotlinx/serialization/modules/SerializersModule;)V", "currentRow", "", "index", "level", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "beginStructure", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "decodeBoolean", "", "decodeByte", "", "decodeChar", "", "decodeCollectionSize", "decodeDouble", "", "decodeElementIndex", "decodeEnum", "enumDescriptor", "decodeFloat", "", "decodeInt", "decodeLong", "", "decodeNotNullMark", "decodeNull", "", "decodeSequentially", "decodeShort", "", "decodeString", "endStructure", "", "kotlinx-serialization-csv"})
public final class CSVDecoder
extends AbstractDecoder {
    @NotNull
    private final List<List<String>> data;
    @NotNull
    private final SerializersModule serializersModule;
    private int index;
    private int level;
    private int currentRow;

    public CSVDecoder(@NotNull List<? extends List<String>> data, @NotNull SerializersModule serializersModule) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        this.data = data;
        this.serializersModule = serializersModule;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @NotNull
    public CSVDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (!(descriptor.getKind() instanceof StructureKind.LIST)) {
            ++this.level;
        }
        return this;
    }

    public boolean decodeNotNullMark() {
        return !Intrinsics.areEqual((Object)this.data.get(this.currentRow).get(this.index), (Object)"");
    }

    public void endStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        --this.level;
        if (this.level == 0) {
            ++this.currentRow;
            this.index = 0;
        }
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        throw new IllegalStateException("Never called, because decodeSequentially returns true".toString());
    }

    public int decodeCollectionSize(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return this.data.size();
    }

    public boolean decodeSequentially() {
        return true;
    }

    @Nullable
    public Void decodeNull() {
        ++this.index;
        return null;
    }

    public boolean decodeBoolean() {
        return Boolean.parseBoolean(this.decodeString());
    }

    public byte decodeByte() {
        return Byte.parseByte(this.decodeString());
    }

    public short decodeShort() {
        return Short.parseShort(this.decodeString());
    }

    public int decodeInt() {
        return Integer.parseInt(this.decodeString());
    }

    public long decodeLong() {
        return Long.parseLong(this.decodeString());
    }

    public float decodeFloat() {
        return Float.parseFloat(this.decodeString());
    }

    public double decodeDouble() {
        return Double.parseDouble(this.decodeString());
    }

    public char decodeChar() {
        return StringsKt.single((CharSequence)this.decodeString());
    }

    @NotNull
    public String decodeString() {
        String string = (String)CollectionsKt.getOrNull(this.data.get(this.currentRow), (int)this.index);
        if (string == null) {
            throw new IllegalStateException(("Missing attribute at " + this.index + " in line " + this.currentRow).toString());
        }
        String value = string;
        ++this.index;
        return value;
    }

    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        return CollectionsKt.indexOf((Iterable)SerialDescriptorKt.getElementNames((SerialDescriptor)enumDescriptor), (Object)this.decodeString());
    }
}

