/*
 * Decompiled with CFR 0.152.
 */
package at.meks.validation;

import at.meks.validation.ValidationConfiguration;
import java.text.MessageFormat;
import java.time.DayOfWeek;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Locale;
import java.util.ResourceBundle;

public class ErrorMessageResolver {
    private ResourceBundle bundle;

    public ErrorMessageResolver() {
        this.initializeBundle();
    }

    private void initializeBundle() {
        this.bundle = ResourceBundle.getBundle("at/meks/validation/errors", ValidationConfiguration.getLocale(), new ResourceBundle.Control(){

            @Override
            public Locale getFallbackLocale(String baseName, Locale locale) {
                return Locale.ROOT;
            }
        });
    }

    public String getLengthIsMoreThanMessage(int size) {
        return MessageFormat.format(this.getBundleString("string.lengthIsMoreThan"), size);
    }

    private String getBundleString(String lengthIsMoreThan) {
        if (!this.bundle.getLocale().equals(ValidationConfiguration.getLocale())) {
            this.initializeBundle();
        }
        return this.bundle.getString(lengthIsMoreThan);
    }

    public String getLengthIsLessThanMessage(int size) {
        return MessageFormat.format(this.getBundleString("string.lengthIsLessThan"), size);
    }

    public String getHasLengthMessage(int length) {
        return MessageFormat.format(this.getBundleString("string.hasLength"), length);
    }

    public String getContainsMessage(String contained) {
        return MessageFormat.format(this.getBundleString("string.contains"), contained);
    }

    public String getIsNotBlankMessage() {
        return this.getBundleString("string.isNotBlank");
    }

    public String getIsInListMessage(Collection<String> validValueSupplier) {
        return MessageFormat.format(this.getBundleString("string.isInList"), String.join((CharSequence)", ", validValueSupplier));
    }

    public String getIsDateMessage(DateTimeFormatter formatter) {
        return MessageFormat.format(this.getBundleString("string.isDate"), formatter);
    }

    public String getIsNumericMessage() {
        return this.getBundleString("string.isNumeric");
    }

    public String getContainsNotOnlyMessage(String containedValue) {
        return MessageFormat.format(this.getBundleString("string.containsNotOnly"), containedValue);
    }

    public String getLengthIsBetweenMessage(Integer minSize, Integer maxSize) {
        return MessageFormat.format(this.getBundleString("string.lengthIsBetween"), minSize, maxSize);
    }

    public String getNotNullMessage() {
        return this.getBundleString("common.mustNotBeNull");
    }

    public String getListContainsOnlyMessage(Object containedValue) {
        return MessageFormat.format(this.getBundleString("list.containsOnly"), containedValue);
    }

    public String getListContainsMessage(Object containedValue) {
        return MessageFormat.format(this.getBundleString("list.contains"), containedValue);
    }

    public String getListDoesNotContainMessage(Object excludedValue) {
        return MessageFormat.format(this.getBundleString("list.doesNotContain"), excludedValue);
    }

    public String getListIsNotEmptyMessage() {
        return this.getBundleString("list.isNotEmpty");
    }

    public String getListIsEmptyMessage() {
        return this.getBundleString("list.isEmpty");
    }

    public String getListHasSizeMessage(int size) {
        return MessageFormat.format(this.getBundleString("list.hasSize"), size);
    }

    public String getListHasMinSizeMessage(int size) {
        return MessageFormat.format(this.getBundleString("list.hasMinSize"), size);
    }

    public String getListHasMaxSizeMessage(int size) {
        return MessageFormat.format(this.getBundleString("list.hasMaxSize"), size);
    }

    public String getIsLessThanMessage(Object compareTo) {
        return MessageFormat.format(this.getBundleString("common.isLessThan"), compareTo);
    }

    public String getIsGreaterThanMessage(Object compareTo) {
        return MessageFormat.format(this.getBundleString("common.isGreaterThan"), compareTo);
    }

    public String getIsBetweenMessage(Object min, Object max) {
        return MessageFormat.format(this.getBundleString("common.isBetween"), min, max);
    }

    public String getIsIntMessage() {
        return this.getBundleString("number.isInt");
    }

    public String getIsByteMessage() {
        return this.getBundleString("number.isByte");
    }

    public String getIsShortMessage() {
        return this.getBundleString("number.isShort");
    }

    public String getIsEqualToMessage(Object comparedTo) {
        return MessageFormat.format(this.getBundleString("common.isEqualTo"), comparedTo);
    }

    public String getIsNotEqualToMessage(Object compareTo) {
        return MessageFormat.format(this.getBundleString("common.isNotEqualTo"), compareTo);
    }

    public String getIsNullMessage() {
        return this.getBundleString("common.isNull");
    }

    public String getIsDateFirstDayOfYearMessage() {
        return this.getBundleString("date.isDateFirstDayOfYear");
    }

    public String getIsDateFirstDayOfMonthMessage() {
        return this.getBundleString("date.isDateFirstDayOfMonth");
    }

    public String getIsTimeStartOfDayMessage() {
        return this.getBundleString("date.isTimeStartOfDay");
    }

    public String getIsLastDayOfMonthMessage() {
        return this.getBundleString("date.isLastDayOfMonth");
    }

    public String getIsDateLastDayOfYearMessage() {
        return this.getBundleString("date.isDateLastDayOfYear");
    }

    public String getIsDateTimeStartOfHourMessage() {
        return this.getBundleString("date.isDateTimeStartOfHour");
    }

    public String getIsDateDayOfWeekMessage(DayOfWeek dayOfWeek) {
        return MessageFormat.format(this.getBundleString("date.isDateDayOfWeek"), dayOfWeek);
    }

    public String getIsTrueMessage() {
        return this.getBundleString("common.isTrue");
    }

    public String getIsFalseMessage() {
        return this.getBundleString("common.isFalse");
    }
}

