/*
 * Decompiled with CFR 0.152.
 */
package at.meks.validation;

import at.meks.validation.result.ValidationResult;
import java.util.function.Function;

@FunctionalInterface
public interface Validation<T> {
    public ValidationResult test(T var1);

    default public Validation<T> and(Validation<T> other) {
        return param -> {
            ValidationResult firstResult = this.test(param);
            return !firstResult.isValid() ? firstResult : other.test(param);
        };
    }

    default public <R> Validation<T> and(Function<T, R> mapper, Validation<R> other) {
        return param -> {
            ValidationResult firstResult = this.test(param);
            return !firstResult.isValid() ? firstResult : other.test(mapper.apply(param));
        };
    }

    default public Validation<T> or(Validation<T> other) {
        return param -> {
            ValidationResult firstResult = this.test(param);
            return firstResult.isValid() ? firstResult : other.test(param);
        };
    }
}

