/*
 * Decompiled with CFR 0.152.
 */
package at.meks.validation.validations.common;

import at.meks.validation.ErrorMessageResolver;
import at.meks.validation.Validation;
import at.meks.validation.result.ErrorDescriptionBuilder;
import at.meks.validation.validations.common.CoreCommonValidations;
import java.util.function.Supplier;

public class CommonValidationsWithErrorCode {
    private static final ErrorMessageResolver MESSAGE_RESOLVER = new ErrorMessageResolver();
    private static final CoreCommonValidations VALIDATIONS = new CoreCommonValidations();

    private CommonValidationsWithErrorCode() {
    }

    public static <T> Validation<T> notNull(String errorCode) {
        return VALIDATIONS.notNull(ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getNotNullMessage(), errorCode));
    }

    public static <T> Validation<T> isNull(String errorCode) {
        return VALIDATIONS.isNull(ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsNullMessage(), errorCode));
    }

    public static <T> Validation<T> isEqualTo(T compareTo, String errorCode) {
        return CommonValidationsWithErrorCode.isEqualTo(() -> compareTo, errorCode);
    }

    public static <T> Validation<T> isEqualTo(Supplier<T> compareTo, String errorCode) {
        return VALIDATIONS.isEqualTo(compareTo, () -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsEqualToMessage(compareTo.get()), errorCode));
    }

    public static <T> Validation<T> isNotEqualTo(T compareTo, String errorCode) {
        return CommonValidationsWithErrorCode.isNotEqualTo(() -> compareTo, errorCode);
    }

    public static <T> Validation<T> isNotEqualTo(Supplier<T> compareTo, String errorCode) {
        return VALIDATIONS.isNotEqualTo(compareTo, () -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsNotEqualToMessage(compareTo.get()), errorCode));
    }

    public static <T, C extends Comparable<T>> Validation<C> isLessThan(T compareTo, String errorCode) {
        return CommonValidationsWithErrorCode.isLessThan(() -> compareTo, errorCode);
    }

    public static <T, C extends Comparable<T>> Validation<C> isLessThan(Supplier<T> compareTo, String errorCode) {
        return VALIDATIONS.isLessThan(compareTo, () -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsLessThanMessage(compareTo.get()), errorCode));
    }

    public static <T, C extends Comparable<T>> Validation<C> isGreaterThan(T compareTo, String errorCode) {
        return CommonValidationsWithErrorCode.isGreaterThan(() -> compareTo, errorCode);
    }

    public static <T, C extends Comparable<T>> Validation<C> isGreaterThan(Supplier<T> compareTo, String errorCode) {
        return VALIDATIONS.isGreaterThan(compareTo, () -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsGreaterThanMessage(compareTo.get()), errorCode));
    }

    public static <T, C extends Comparable<T>> Validation<C> isBetween(T min, T max, String errorCode) {
        return CommonValidationsWithErrorCode.isBetween(() -> min, () -> max, errorCode);
    }

    public static <T, C extends Comparable<T>> Validation<C> isBetween(Supplier<T> min, Supplier<T> max, String errorCode) {
        return VALIDATIONS.isBetween(min, max, () -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsBetweenMessage(min.get(), max.get()), errorCode));
    }

    public static Validation<Boolean> isTrue(String errorCode) {
        return VALIDATIONS.isTrue(() -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsTrueMessage(), errorCode));
    }

    public static Validation<Boolean> isFalse(String errorCode) {
        return VALIDATIONS.isFalse(() -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsFalseMessage(), errorCode));
    }
}

