/*
 * Decompiled with CFR 0.152.
 */
package at.meks.validation.validations.date;

import at.meks.validation.ErrorMessageResolver;
import at.meks.validation.Validation;
import at.meks.validation.result.ErrorDescriptionBuilder;
import at.meks.validation.validations.common.CommonValidations;
import at.meks.validation.validations.date.CoreDateValidations;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.function.Supplier;

public class DateValidations {
    private static final ErrorMessageResolver MESSAGE_RESOLVER = new ErrorMessageResolver();
    private static final CoreDateValidations VALIDATIONS = new CoreDateValidations();

    private DateValidations() {
    }

    public static Validation<LocalDate> isLocalDateAfter(LocalDate minDate) {
        return CommonValidations.isGreaterThan(minDate);
    }

    public static Validation<Comparable<LocalDate>> isLocalDateAfter(Supplier<LocalDate> supplierMinDate) {
        return CommonValidations.isGreaterThan(supplierMinDate);
    }

    public static Validation<LocalDateTime> isLocalDateTimeAfter(LocalDateTime minDate) {
        return CommonValidations.isGreaterThan(minDate);
    }

    public static Validation<Comparable<LocalDateTime>> isLocalDateTimeAfter(Supplier<LocalDateTime> supplierMinDate) {
        return CommonValidations.isGreaterThan(supplierMinDate);
    }

    public static Validation<ZonedDateTime> isZonedDateTimeAfter(ZonedDateTime minDate) {
        return CommonValidations.isGreaterThan(minDate);
    }

    public static Validation<Comparable<ZonedDateTime>> isZonedDateTimeAfter(Supplier<ZonedDateTime> supplierMinDate) {
        return CommonValidations.isGreaterThan(supplierMinDate);
    }

    public static Validation<LocalDate> isLocalDateBefore(LocalDate maxDate) {
        return CommonValidations.isLessThan(maxDate);
    }

    public static Validation<Comparable<LocalDate>> isLocalDateBefore(Supplier<LocalDate> supplierMaxDate) {
        return CommonValidations.isLessThan(supplierMaxDate);
    }

    public static Validation<LocalDateTime> isLocalDateTimeBefore(LocalDateTime maxDate) {
        return CommonValidations.isLessThan(maxDate);
    }

    public static Validation<Comparable<LocalDateTime>> isLocalDateTimeBefore(Supplier<LocalDateTime> supplierMaxDate) {
        return CommonValidations.isLessThan(supplierMaxDate);
    }

    public static Validation<ZonedDateTime> isZonedDateTimeBefore(ZonedDateTime maxDate) {
        return CommonValidations.isLessThan(maxDate);
    }

    public static Validation<Comparable<ZonedDateTime>> isZonedDateTimeBefore(Supplier<ZonedDateTime> supplierMaxDate) {
        return CommonValidations.isLessThan(supplierMaxDate);
    }

    public static Validation<LocalDate> isLocalDateBetween(LocalDate minDate, LocalDate maxDate) {
        return CommonValidations.isBetween(minDate, maxDate);
    }

    public static Validation<Comparable<LocalDate>> isLocalDateBetween(Supplier<LocalDate> supplierMinDate, Supplier<LocalDate> supplierMaxDate) {
        return CommonValidations.isBetween(supplierMinDate, supplierMaxDate);
    }

    public static Validation<LocalDateTime> isLocalDateTimeBetween(LocalDateTime minDate, LocalDateTime maxDate) {
        return CommonValidations.isBetween(minDate, maxDate);
    }

    public static Validation<Comparable<LocalDateTime>> isLocalDateTimeBetween(Supplier<LocalDateTime> supplierMinDate, Supplier<LocalDateTime> supplierMaxDate) {
        return CommonValidations.isBetween(supplierMinDate, supplierMaxDate);
    }

    public static Validation<ZonedDateTime> isZonedDateTimeBetween(ZonedDateTime minDate, ZonedDateTime maxDate) {
        return CommonValidations.isBetween(minDate, maxDate);
    }

    public static Validation<Comparable<ZonedDateTime>> isZonedDateTimeBetween(Supplier<ZonedDateTime> supplierMinDate, Supplier<ZonedDateTime> supplierMaxDate) {
        return CommonValidations.isBetween(supplierMinDate, supplierMaxDate);
    }

    public static Validation<LocalDate> isLocalDateFirstDayOfYear() {
        return VALIDATIONS.isLocalDateFirstDayOfYear(() -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getIsDateFirstDayOfYearMessage()));
    }

    public static Validation<LocalDateTime> isLocalDateTimeFirstDayOfYear() {
        return VALIDATIONS.isLocalDateTimeFirstDayOfYear(() -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getIsDateFirstDayOfYearMessage()));
    }

    public static Validation<ZonedDateTime> isZonedDateTimeFirstDayOfYear() {
        return VALIDATIONS.isZonedDateTimeFirstDayOfYear(() -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getIsDateFirstDayOfYearMessage()));
    }

    public static Validation<LocalDate> isLocalDateLastDayOfYear() {
        return VALIDATIONS.isLocalDateLastDayOfYear(() -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getIsDateLastDayOfYearMessage()));
    }

    public static Validation<LocalDateTime> isLocalDateTimeLastDayOfYear() {
        return VALIDATIONS.isLocalDateTimeLastDayOfYear(() -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getIsDateLastDayOfYearMessage()));
    }

    public static Validation<ZonedDateTime> isZonedDateTimeLastDayOfYear() {
        return VALIDATIONS.isZonedDateTimeLastDayOfYear(() -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getIsDateLastDayOfYearMessage()));
    }

    public static Validation<LocalDate> isLocalDateFirstDayOfMonth() {
        return VALIDATIONS.isLocalDateFirstDayOfMonth(() -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getIsDateFirstDayOfMonthMessage()));
    }

    public static Validation<LocalDateTime> isLocalDateTimeFirstDayOfMonth() {
        return VALIDATIONS.isLocalDateTimeFirstDayOfMonth(() -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getIsDateFirstDayOfMonthMessage()));
    }

    public static Validation<ZonedDateTime> isZonedDateTimeFirstDayOfMonth() {
        return VALIDATIONS.isZonedDateTimeFirstDayOfMonth(() -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getIsDateFirstDayOfMonthMessage()));
    }

    public static Validation<LocalDateTime> isLocalDateTimeStartOfDay() {
        return VALIDATIONS.isLocalDateTimeStartOfDay(() -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getIsTimeStartOfDayMessage()));
    }

    public static Validation<ZonedDateTime> isZonedDateTimeStartOfDay() {
        return VALIDATIONS.isZonedDateTimeStartOfDay(() -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getIsTimeStartOfDayMessage()));
    }

    public static Validation<LocalDate> isLocalDateLastDayOfMonth() {
        return VALIDATIONS.isLocalDateLastDayOfMonth(() -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getIsLastDayOfMonthMessage()));
    }

    public static Validation<LocalDateTime> isLocalDateTimeLastDayOfMonth() {
        return VALIDATIONS.isLocalDateTimeLastDayOfMonth(() -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getIsLastDayOfMonthMessage()));
    }

    public static Validation<ZonedDateTime> isZonedDateTimeLastDayOfMonth() {
        return VALIDATIONS.isZonedDateTimeLastDayOfMonth(() -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getIsLastDayOfMonthMessage()));
    }

    public static Validation<LocalDateTime> isLocalDateTimeStartOfHour() {
        return VALIDATIONS.isLocalDateTimeStartOfHour(() -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getIsDateTimeStartOfHourMessage()));
    }

    public static Validation<ZonedDateTime> isZonedDateTimeStartOfHour() {
        return VALIDATIONS.isZonedDateTimeStartOfHour(() -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getIsDateTimeStartOfHourMessage()));
    }

    public static Validation<LocalDate> isLocalDateDayOfWeek(DayOfWeek dayOfWeek) {
        return VALIDATIONS.isLocalDateDayOfWeek(dayOfWeek, () -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getIsDateDayOfWeekMessage(dayOfWeek)));
    }

    public static Validation<LocalDateTime> isLocalDateTimeDayOfWeek(DayOfWeek dayOfWeek) {
        return VALIDATIONS.isLocalDateTimeDayOfWeek(dayOfWeek, () -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getIsDateDayOfWeekMessage(dayOfWeek)));
    }

    public static Validation<ZonedDateTime> isZonedDateTimeDayOfWeek(DayOfWeek dayOfWeek) {
        return VALIDATIONS.isZonedDateTimeDayOfWeek(dayOfWeek, () -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getIsDateDayOfWeekMessage(dayOfWeek)));
    }
}

