/*
 * Decompiled with CFR 0.152.
 */
package at.meks.validation.validations.date;

import at.meks.validation.ErrorMessageResolver;
import at.meks.validation.Validation;
import at.meks.validation.result.ErrorDescriptionBuilder;
import at.meks.validation.validations.common.CommonValidationsWithErrorCode;
import at.meks.validation.validations.date.CoreDateValidations;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.function.Supplier;

public class DateValidationsWithErrorCode {
    private static final ErrorMessageResolver MESSAGE_RESOLVER = new ErrorMessageResolver();
    private static final CoreDateValidations VALIDATIONS = new CoreDateValidations();

    private DateValidationsWithErrorCode() {
    }

    public static Validation<LocalDate> isLocalDateAfter(LocalDate minDate, String errorCode) {
        return CommonValidationsWithErrorCode.isGreaterThan(minDate, errorCode);
    }

    public static Validation<Comparable<LocalDate>> isLocalDateAfter(Supplier<LocalDate> supplierMinDate, String errorCode) {
        return CommonValidationsWithErrorCode.isGreaterThan(supplierMinDate, errorCode);
    }

    public static Validation<LocalDateTime> isLocalDateTimeAfter(LocalDateTime minDate, String errorCode) {
        return CommonValidationsWithErrorCode.isGreaterThan(minDate, errorCode);
    }

    public static Validation<Comparable<LocalDateTime>> isLocalDateTimeAfter(Supplier<LocalDateTime> supplierMinDate, String errorCode) {
        return CommonValidationsWithErrorCode.isGreaterThan(supplierMinDate, errorCode);
    }

    public static Validation<ZonedDateTime> isZonedDateTimeAfter(ZonedDateTime minDate, String errorCode) {
        return CommonValidationsWithErrorCode.isGreaterThan(minDate, errorCode);
    }

    public static Validation<Comparable<ZonedDateTime>> isZonedDateTimeAfter(Supplier<ZonedDateTime> supplierMinDate, String errorCode) {
        return CommonValidationsWithErrorCode.isGreaterThan(supplierMinDate, errorCode);
    }

    public static Validation<LocalDate> isLocalDateBefore(LocalDate maxDate, String errorCode) {
        return CommonValidationsWithErrorCode.isLessThan(maxDate, errorCode);
    }

    public static Validation<Comparable<LocalDate>> isLocalDateBefore(Supplier<LocalDate> supplierMaxDate, String errorCode) {
        return CommonValidationsWithErrorCode.isLessThan(supplierMaxDate, errorCode);
    }

    public static Validation<LocalDateTime> isLocalDateTimeBefore(LocalDateTime maxDate, String errorCode) {
        return CommonValidationsWithErrorCode.isLessThan(maxDate, errorCode);
    }

    public static Validation<Comparable<LocalDateTime>> isLocalDateTimeBefore(Supplier<LocalDateTime> supplierMaxDate, String errorCode) {
        return CommonValidationsWithErrorCode.isLessThan(supplierMaxDate, errorCode);
    }

    public static Validation<ZonedDateTime> isZonedDateTimeBefore(ZonedDateTime maxDate, String errorCode) {
        return CommonValidationsWithErrorCode.isLessThan(maxDate, errorCode);
    }

    public static Validation<Comparable<ZonedDateTime>> isZonedDateTimeBefore(Supplier<ZonedDateTime> supplierMaxDate, String errorCode) {
        return CommonValidationsWithErrorCode.isLessThan(supplierMaxDate, errorCode);
    }

    public static Validation<LocalDate> isLocalDateBetween(LocalDate minDate, LocalDate maxDate, String errorCode) {
        return CommonValidationsWithErrorCode.isBetween(minDate, maxDate, errorCode);
    }

    public static Validation<Comparable<LocalDate>> isLocalDateBetween(Supplier<LocalDate> supplierMinDate, Supplier<LocalDate> supplierMaxDate, String errorCode) {
        return CommonValidationsWithErrorCode.isBetween(supplierMinDate, supplierMaxDate, errorCode);
    }

    public static Validation<LocalDateTime> isLocalDateTimeBetween(LocalDateTime minDate, LocalDateTime maxDate, String errorCode) {
        return CommonValidationsWithErrorCode.isBetween(minDate, maxDate, errorCode);
    }

    public static Validation<Comparable<LocalDateTime>> isLocalDateTimeBetween(Supplier<LocalDateTime> supplierMinDate, Supplier<LocalDateTime> supplierMaxDate, String errorCode) {
        return CommonValidationsWithErrorCode.isBetween(supplierMinDate, supplierMaxDate, errorCode);
    }

    public static Validation<ZonedDateTime> isZonedDateTimeBetween(ZonedDateTime minDate, ZonedDateTime maxDate, String errorCode) {
        return CommonValidationsWithErrorCode.isBetween(minDate, maxDate, errorCode);
    }

    public static Validation<Comparable<ZonedDateTime>> isZonedDateTimeBetween(Supplier<ZonedDateTime> supplierMinDate, Supplier<ZonedDateTime> supplierMaxDate, String errorCode) {
        return CommonValidationsWithErrorCode.isBetween(supplierMinDate, supplierMaxDate, errorCode);
    }

    public static Validation<LocalDate> isLocalDateFirstDayOfYear(String errorCode) {
        return VALIDATIONS.isLocalDateFirstDayOfYear(() -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsDateFirstDayOfYearMessage(), errorCode));
    }

    public static Validation<LocalDateTime> isLocalDateTimeFirstDayOfYear(String errorCode) {
        return VALIDATIONS.isLocalDateTimeFirstDayOfYear(() -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsDateFirstDayOfYearMessage(), errorCode));
    }

    public static Validation<ZonedDateTime> isZonedDateTimeFirstDayOfYear(String errorCode) {
        return VALIDATIONS.isZonedDateTimeFirstDayOfYear(() -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsDateFirstDayOfYearMessage(), errorCode));
    }

    public static Validation<LocalDate> isLocalDateLastDayOfYear(String errorCode) {
        return VALIDATIONS.isLocalDateLastDayOfYear(() -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsDateLastDayOfYearMessage(), errorCode));
    }

    public static Validation<LocalDateTime> isLocalDateTimeLastDayOfYear(String errorCode) {
        return VALIDATIONS.isLocalDateTimeLastDayOfYear(() -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsDateLastDayOfYearMessage(), errorCode));
    }

    public static Validation<ZonedDateTime> isZonedDateTimeLastDayOfYear(String errorCode) {
        return VALIDATIONS.isZonedDateTimeLastDayOfYear(() -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsDateLastDayOfYearMessage(), errorCode));
    }

    public static Validation<LocalDate> isLocalDateFirstDayOfMonth(String errorCode) {
        return VALIDATIONS.isLocalDateFirstDayOfMonth(() -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsDateFirstDayOfMonthMessage(), errorCode));
    }

    public static Validation<LocalDateTime> isLocalDateTimeFirstDayOfMonth(String errorCode) {
        return VALIDATIONS.isLocalDateTimeFirstDayOfMonth(() -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsDateFirstDayOfMonthMessage(), errorCode));
    }

    public static Validation<ZonedDateTime> isZonedDateTimeFirstDayOfMonth(String errorCode) {
        return VALIDATIONS.isZonedDateTimeFirstDayOfMonth(() -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsDateFirstDayOfMonthMessage(), errorCode));
    }

    public static Validation<LocalDateTime> isLocalDateTimeStartOfDay(String errorCode) {
        return VALIDATIONS.isLocalDateTimeStartOfDay(() -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsTimeStartOfDayMessage(), errorCode));
    }

    public static Validation<ZonedDateTime> isZonedDateTimeStartOfDay(String errorCode) {
        return VALIDATIONS.isZonedDateTimeStartOfDay(() -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsTimeStartOfDayMessage(), errorCode));
    }

    public static Validation<LocalDate> isLocalDateLastDayOfMonth(String errorCode) {
        return VALIDATIONS.isLocalDateLastDayOfMonth(() -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsLastDayOfMonthMessage(), errorCode));
    }

    public static Validation<LocalDateTime> isLocalDateTimeLastDayOfMonth(String errorCode) {
        return VALIDATIONS.isLocalDateTimeLastDayOfMonth(() -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsLastDayOfMonthMessage(), errorCode));
    }

    public static Validation<ZonedDateTime> isZonedDateTimeLastDayOfMonth(String errorCode) {
        return VALIDATIONS.isZonedDateTimeLastDayOfMonth(() -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsLastDayOfMonthMessage(), errorCode));
    }

    public static Validation<LocalDateTime> isLocalDateTimeStartOfHour(String errorCode) {
        return VALIDATIONS.isLocalDateTimeStartOfHour(() -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsDateTimeStartOfHourMessage(), errorCode));
    }

    public static Validation<ZonedDateTime> isZonedDateTimeStartOfHour(String errorCode) {
        return VALIDATIONS.isZonedDateTimeStartOfHour(() -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsDateTimeStartOfHourMessage(), errorCode));
    }

    public static Validation<LocalDate> isLocalDateDayOfWeek(DayOfWeek dayOfWeek, String errorCode) {
        return VALIDATIONS.isLocalDateDayOfWeek(dayOfWeek, () -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsDateDayOfWeekMessage(dayOfWeek), errorCode));
    }

    public static Validation<LocalDateTime> isLocalDateTimeDayOfWeek(DayOfWeek dayOfWeek, String errorCode) {
        return VALIDATIONS.isLocalDateTimeDayOfWeek(dayOfWeek, () -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsDateDayOfWeekMessage(dayOfWeek), errorCode));
    }

    public static Validation<ZonedDateTime> isZonedDateTimeDayOfWeek(DayOfWeek dayOfWeek, String errorCode) {
        return VALIDATIONS.isZonedDateTimeDayOfWeek(dayOfWeek, () -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsDateDayOfWeekMessage(dayOfWeek), errorCode));
    }
}

