/*
 * Decompiled with CFR 0.152.
 */
package at.meks.validation.validations.list;

import at.meks.validation.ErrorMessageResolver;
import at.meks.validation.Validation;
import at.meks.validation.result.ErrorDescriptionBuilder;
import at.meks.validation.validations.list.CoreListValidations;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ListValidations {
    private static final ErrorMessageResolver MESSAGE_RESOLVER = new ErrorMessageResolver();
    private static final CoreListValidations VALIDATIONS = new CoreListValidations();

    private ListValidations() {
    }

    public static <T> Validation<List<T>> containsOnly(T containedValue) {
        return ListValidations.containsOnly(() -> containedValue);
    }

    public static <T> Validation<List<T>> containsOnly(Supplier<T> containedValue) {
        return VALIDATIONS.containsOnly(containedValue, () -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getListContainsOnlyMessage(containedValue.get())));
    }

    public static <T> Validation<List<T>> contains(T containedValue) {
        return ListValidations.contains(() -> containedValue);
    }

    public static <T> Validation<List<T>> contains(Supplier<T> containedValue) {
        return VALIDATIONS.contains(containedValue, () -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getListContainsMessage(containedValue.get())));
    }

    public static <T> Validation<List<T>> doesNotContain(T excludedValue) {
        return ListValidations.doesNotContain(() -> excludedValue);
    }

    public static <T> Validation<List<T>> doesNotContain(Supplier<T> excludedValue) {
        return VALIDATIONS.doesNotContain(excludedValue, () -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getListDoesNotContainMessage(excludedValue.get())));
    }

    public static <T> Validation<List<T>> isNotEmpty() {
        return VALIDATIONS.isNotEmpty(ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getListIsNotEmptyMessage()));
    }

    public static <T> Validation<List<T>> isEmpty() {
        return VALIDATIONS.isEmpty(ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getListIsEmptyMessage()));
    }

    public static <T> Validation<List<T>> hasSize(int size) {
        return ListValidations.hasSize(() -> size);
    }

    public static <T> Validation<List<T>> hasSize(Supplier<Integer> size) {
        return VALIDATIONS.hasSize(size, () -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getListHasSizeMessage((Integer)size.get())));
    }

    public static <T> Validation<List<T>> hasMinSize(int size) {
        return ListValidations.hasMinSize(() -> size);
    }

    public static <T> Validation<List<T>> hasMinSize(Supplier<Integer> size) {
        return VALIDATIONS.hasMinSize(size, () -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getListHasMinSizeMessage((Integer)size.get())));
    }

    public static <T> Validation<List<T>> hasMaxSize(int size) {
        return ListValidations.hasMaxSize(() -> size);
    }

    public static <T> Validation<List<T>> hasMaxSize(Supplier<Integer> size) {
        return VALIDATIONS.hasMaxSize(size, () -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getListHasMaxSizeMessage((Integer)size.get())));
    }

    public static <T, E> Validation<List<T>> onProperty(Function<T, E> function, Validation<List<E>> validation) {
        return VALIDATIONS.onProperty(function, validation);
    }

    public static <T> Validation<List<T>> forType(Class<T> listType, Validation<List<T>> validation) {
        return VALIDATIONS.forType(listType, validation);
    }
}

