/*
 * Decompiled with CFR 0.152.
 */
package at.meks.validation.validations.string;

import at.meks.validation.SimpleValidation;
import at.meks.validation.Validation;
import at.meks.validation.result.ErrorDescription;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.function.Supplier;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

class CoreStringValidations {
    CoreStringValidations() {
    }

    Validation<String> lengthIsMoreThan(Supplier<Integer> size, Supplier<ErrorDescription> errorDescription) {
        return SimpleValidation.from(s -> StringUtils.length((CharSequence)s) > (Integer)size.get(), errorDescription);
    }

    Validation<String> lengthIsLessThan(Supplier<Integer> size, Supplier<ErrorDescription> errorDescription) {
        return SimpleValidation.from(s -> StringUtils.length((CharSequence)s) < (Integer)size.get(), errorDescription);
    }

    Validation<String> lengthIsBetween(Supplier<Integer> minSize, Supplier<Integer> maxSize, Supplier<ErrorDescription> errorDescription) {
        return this.lengthIsMoreThan(() -> (Integer)minSize.get() - 1, errorDescription).and(this.lengthIsLessThan(() -> (Integer)maxSize.get() + 1, errorDescription));
    }

    Validation<String> hasLength(Supplier<Integer> length, Supplier<ErrorDescription> errorDescription) {
        return SimpleValidation.from(s -> StringUtils.length((CharSequence)s) == (Integer)length.get(), errorDescription);
    }

    Validation<String> contains(Supplier<String> c, Supplier<ErrorDescription> errorDescription) {
        return SimpleValidation.from(s -> StringUtils.contains((CharSequence)s, (CharSequence)((CharSequence)c.get())), errorDescription);
    }

    Validation<String> isNotBlank(ErrorDescription errorDescription) {
        return SimpleValidation.from(StringUtils::isNotBlank, () -> errorDescription);
    }

    Validation<String> isInArray(Supplier<String[]> validValueSupplier, Supplier<ErrorDescription> errorDescription) {
        return SimpleValidation.from(s -> ArrayUtils.contains((Object[])((Object[])validValueSupplier.get()), (Object)s), errorDescription);
    }

    Validation<String> isInList(Supplier<Collection<String>> validValueSupplier, Supplier<ErrorDescription> errorDescription) {
        return SimpleValidation.from(validValueSupplier.get()::contains, errorDescription);
    }

    Validation<String> isDate(Supplier<DateTimeFormatter> formatter, Supplier<ErrorDescription> errorDescription) {
        return SimpleValidation.from(s -> {
            try {
                ((DateTimeFormatter)formatter.get()).parse((CharSequence)s);
                return true;
            }
            catch (DateTimeParseException e) {
                return false;
            }
        }, errorDescription);
    }

    Validation<String> isNumeric(ErrorDescription errorDescription) {
        return SimpleValidation.from(StringUtils::isNumeric, () -> errorDescription);
    }

    Validation<String> containsNotOnly(Supplier<String> containedValue, Supplier<ErrorDescription> errorDescription) {
        return SimpleValidation.from(s -> !StringUtils.containsOnly((CharSequence)s, (String)((String)containedValue.get())), errorDescription);
    }
}

