/*
 * Decompiled with CFR 0.152.
 */
package at.meks.validation.validations.string;

import at.meks.validation.ErrorMessageResolver;
import at.meks.validation.Validation;
import at.meks.validation.result.ErrorDescriptionBuilder;
import at.meks.validation.validations.string.CoreStringValidations;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;

public class StringValidations {
    private static final ErrorMessageResolver MESSAGE_RESOLVER = new ErrorMessageResolver();
    private static final CoreStringValidations VALIDATIONS = new CoreStringValidations();

    private StringValidations() {
    }

    public static Validation<String> lengthIsMoreThan(int size) {
        return StringValidations.lengthIsMoreThan(() -> size);
    }

    public static Validation<String> lengthIsMoreThan(Supplier<Integer> size) {
        return VALIDATIONS.lengthIsMoreThan(size, () -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getLengthIsMoreThanMessage((Integer)size.get())));
    }

    public static Validation<String> lengthIsLessThan(int size) {
        return StringValidations.lengthIsLessThan(() -> size);
    }

    public static Validation<String> lengthIsLessThan(Supplier<Integer> size) {
        return VALIDATIONS.lengthIsLessThan(size, () -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getLengthIsLessThanMessage((Integer)size.get())));
    }

    public static Validation<String> lengthIsBetween(int minSize, int maxSize) {
        return StringValidations.lengthIsBetween(() -> minSize, () -> maxSize);
    }

    public static Validation<String> lengthIsBetween(Supplier<Integer> minSize, Supplier<Integer> maxSize) {
        return VALIDATIONS.lengthIsBetween(minSize, maxSize, () -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getLengthIsBetweenMessage((Integer)minSize.get(), (Integer)maxSize.get())));
    }

    public static Validation<String> hasLength(int length) {
        return StringValidations.hasLength(() -> length);
    }

    public static Validation<String> hasLength(Supplier<Integer> length) {
        return VALIDATIONS.hasLength(length, () -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getHasLengthMessage((Integer)length.get())));
    }

    public static Validation<String> contains(String contained) {
        return StringValidations.contains(() -> contained);
    }

    public static Validation<String> contains(Supplier<String> contained) {
        return VALIDATIONS.contains(contained, () -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getContainsMessage((String)contained.get())));
    }

    public static Validation<String> isNotBlank() {
        return VALIDATIONS.isNotBlank(ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getIsNotBlankMessage()));
    }

    public static Validation<String> isInArray(Supplier<String[]> validValueSupplier) {
        return VALIDATIONS.isInArray(validValueSupplier, () -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getIsInListMessage(Arrays.asList((Object[])validValueSupplier.get()))));
    }

    public static Validation<String> isInList(Supplier<Collection<String>> validValueSupplier) {
        return VALIDATIONS.isInList(validValueSupplier, () -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getIsInListMessage((Collection)validValueSupplier.get())));
    }

    public static Validation<String> isDate(DateTimeFormatter formatter) {
        return StringValidations.isDate(() -> formatter);
    }

    public static Validation<String> isDate(Supplier<DateTimeFormatter> formatter) {
        return VALIDATIONS.isDate(formatter, () -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getIsDateMessage((DateTimeFormatter)formatter.get())));
    }

    public static Validation<String> isNumeric() {
        return VALIDATIONS.isNumeric(ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getIsNumericMessage()));
    }

    public static Validation<String> containsNotOnly(String containedValue) {
        return StringValidations.containsNotOnly(() -> containedValue);
    }

    public static Validation<String> containsNotOnly(Supplier<String> containedValue) {
        return VALIDATIONS.containsNotOnly(containedValue, () -> ErrorDescriptionBuilder.withMessage(MESSAGE_RESOLVER.getContainsNotOnlyMessage((String)containedValue.get())));
    }
}

