/*
 * Decompiled with CFR 0.152.
 */
package at.meks.validation.validations.string;

import at.meks.validation.ErrorMessageResolver;
import at.meks.validation.Validation;
import at.meks.validation.result.ErrorDescriptionBuilder;
import at.meks.validation.validations.string.CoreStringValidations;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;

public class StringValidationsWithErrorCode {
    private static final ErrorMessageResolver MESSAGE_RESOLVER = new ErrorMessageResolver();
    private static final CoreStringValidations VALIDATIONS = new CoreStringValidations();

    private StringValidationsWithErrorCode() {
    }

    public static Validation<String> lengthIsMoreThan(int size, String errorCode) {
        return StringValidationsWithErrorCode.lengthIsMoreThan(() -> size, errorCode);
    }

    public static Validation<String> lengthIsMoreThan(Supplier<Integer> size, String errorCode) {
        return VALIDATIONS.lengthIsMoreThan(size, () -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getLengthIsMoreThanMessage((Integer)size.get()), errorCode));
    }

    public static Validation<String> lengthIsLessThan(int size, String errorCode) {
        return StringValidationsWithErrorCode.lengthIsLessThan(() -> size, errorCode);
    }

    public static Validation<String> lengthIsLessThan(Supplier<Integer> size, String errorCode) {
        return VALIDATIONS.lengthIsLessThan(size, () -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getLengthIsLessThanMessage((Integer)size.get()), errorCode));
    }

    public static Validation<String> lengthIsBetween(int minSize, int maxSize, String errorCode) {
        return StringValidationsWithErrorCode.lengthIsBetween(() -> minSize, () -> maxSize, errorCode);
    }

    public static Validation<String> lengthIsBetween(Supplier<Integer> minSize, Supplier<Integer> maxSize, String errorCode) {
        return VALIDATIONS.lengthIsBetween(minSize, maxSize, () -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getLengthIsBetweenMessage((Integer)minSize.get(), (Integer)maxSize.get()), errorCode));
    }

    public static Validation<String> hasLength(int length, String errorCode) {
        return StringValidationsWithErrorCode.hasLength(() -> length, errorCode);
    }

    public static Validation<String> hasLength(Supplier<Integer> length, String errorCode) {
        return VALIDATIONS.hasLength(length, () -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getHasLengthMessage((Integer)length.get()), errorCode));
    }

    public static Validation<String> contains(String contained, String errorCode) {
        return StringValidationsWithErrorCode.contains(() -> contained, errorCode);
    }

    public static Validation<String> contains(Supplier<String> contained, String errorCode) {
        return VALIDATIONS.contains(contained, () -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getContainsMessage((String)contained.get()), errorCode));
    }

    public static Validation<String> isNotBlank(String errorCode) {
        return VALIDATIONS.isNotBlank(ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsNotBlankMessage(), errorCode));
    }

    public static Validation<String> isInArray(Supplier<String[]> validValueSupplier, String errorCode) {
        return VALIDATIONS.isInArray(validValueSupplier, () -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsInListMessage(Arrays.asList((Object[])validValueSupplier.get())), errorCode));
    }

    public static Validation<String> isInList(Supplier<Collection<String>> validValueSupplier, String errorCode) {
        return VALIDATIONS.isInList(validValueSupplier, () -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsInListMessage((Collection)validValueSupplier.get()), errorCode));
    }

    public static Validation<String> isDate(DateTimeFormatter formatter, String errorCode) {
        return StringValidationsWithErrorCode.isDate(() -> formatter, errorCode);
    }

    public static Validation<String> isDate(Supplier<DateTimeFormatter> formatter, String errorCode) {
        return VALIDATIONS.isDate(formatter, () -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsDateMessage((DateTimeFormatter)formatter.get()), errorCode));
    }

    public static Validation<String> isNumeric(String errorCode) {
        return VALIDATIONS.isNumeric(ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getIsNumericMessage(), errorCode));
    }

    public static Validation<String> containsNotOnly(String containedValue, String errorCode) {
        return StringValidationsWithErrorCode.containsNotOnly(() -> containedValue, errorCode);
    }

    public static Validation<String> containsNotOnly(Supplier<String> containedValue, String errorCode) {
        return VALIDATIONS.containsNotOnly(containedValue, () -> ErrorDescriptionBuilder.withCode(MESSAGE_RESOLVER.getContainsNotOnlyMessage((String)containedValue.get()), errorCode));
    }
}

