// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.model



class RequestCertificateRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the private certificate authority (CA) that will be used
     * to issue the certificate. If you do not provide an ARN and you are trying to request a private
     * certificate, ACM will attempt to issue a public certificate. For more information about
     * private CAs, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaWelcome.html">Amazon Web Services Certificate Manager Private Certificate Authority (PCA) user guide. The ARN must have the following form:
     *
     *
     * arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
     */
    val certificateAuthorityArn: kotlin.String? = builder.certificateAuthorityArn
    /**
     * Fully qualified domain name (FQDN), such as www.example.com, that you want to secure with
     * an ACM certificate. Use an asterisk (*) to create a wildcard certificate that protects
     * several sites in the same domain. For example, *.example.com protects www.example.com,
     * site.example.com, and images.example.com.
     *
     * The first domain name you enter cannot exceed 64 octets, including periods. Each
     * subsequent Subject Alternative Name (SAN), however, can be up to 253 octets in length.
     */
    val domainName: kotlin.String? = builder.domainName
    /**
     * The domain name that you want ACM to use to send you emails so that you can validate
     * domain ownership.
     */
    val domainValidationOptions: List<DomainValidationOption>? = builder.domainValidationOptions
    /**
     * Customer chosen string that can be used to distinguish between calls to
     * RequestCertificate. Idempotency tokens time out after one hour. Therefore, if
     * you call RequestCertificate multiple times with the same idempotency token within
     * one hour, ACM recognizes that you are requesting only one certificate and will issue only
     * one. If you change the idempotency token for each call, ACM recognizes that you are
     * requesting multiple certificates.
     */
    val idempotencyToken: kotlin.String? = builder.idempotencyToken
    /**
     * Currently, you can use this parameter to specify whether to add the certificate to a
     * certificate transparency log. Certificate transparency makes it possible to detect SSL/TLS
     * certificates that have been mistakenly or maliciously issued. Certificates that have not been
     * logged typically produce an error message in a browser. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-bestpractices.html#best-practices-transparency">Opting Out of Certificate Transparency Logging.
     */
    val options: aws.sdk.kotlin.services.acm.model.CertificateOptions? = builder.options
    /**
     * Additional FQDNs to be included in the Subject Alternative Name extension of the ACM
     * certificate. For example, add the name www.example.net to a certificate for which the
     * DomainName field is www.example.com if users can reach your site by using
     * either name. The maximum number of domain names that you can add to an ACM certificate is
     * 100. However, the initial quota is 10 domain names. If you need more than 10 names, you must
     * request a quota increase. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-limits.html">Quotas.
     *
     * The maximum length of a SAN DNS name is 253 octets. The name is made up of multiple
     * labels separated by periods. No label can be longer than 63 octets. Consider the following
     * examples:
     *
     *
     *
     *
     * (63 octets).(63 octets).(63 octets).(61 octets) is legal because the
     * total length is 253 octets (63+1+63+1+63+1+61) and no label exceeds 63 octets.
     *
     *
     * (64 octets).(63 octets).(63 octets).(61 octets) is not legal because the
     * total length exceeds 253 octets (64+1+63+1+63+1+61) and the first label exceeds 63
     * octets.
     *
     *
     * (63 octets).(63 octets).(63 octets).(62 octets) is not legal because the
     * total length of the DNS name (63+1+63+1+63+1+62) exceeds 253 octets.
     */
    val subjectAlternativeNames: List<String>? = builder.subjectAlternativeNames
    /**
     * One or more resource tags to associate with the certificate.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The method you want to use if you are requesting a public certificate to validate that you
     * own or control domain. You can <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html">validate with DNS or <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-email.html">validate with
     * email. We recommend that you use DNS validation.
     */
    val validationMethod: aws.sdk.kotlin.services.acm.model.ValidationMethod? = builder.validationMethod

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acm.model.RequestCertificateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RequestCertificateRequest(")
        append("certificateAuthorityArn=$certificateAuthorityArn,")
        append("domainName=$domainName,")
        append("domainValidationOptions=$domainValidationOptions,")
        append("idempotencyToken=$idempotencyToken,")
        append("options=$options,")
        append("subjectAlternativeNames=$subjectAlternativeNames,")
        append("tags=$tags,")
        append("validationMethod=$validationMethod)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateAuthorityArn?.hashCode() ?: 0
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (domainValidationOptions?.hashCode() ?: 0)
        result = 31 * result + (idempotencyToken?.hashCode() ?: 0)
        result = 31 * result + (options?.hashCode() ?: 0)
        result = 31 * result + (subjectAlternativeNames?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (validationMethod?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RequestCertificateRequest

        if (certificateAuthorityArn != other.certificateAuthorityArn) return false
        if (domainName != other.domainName) return false
        if (domainValidationOptions != other.domainValidationOptions) return false
        if (idempotencyToken != other.idempotencyToken) return false
        if (options != other.options) return false
        if (subjectAlternativeNames != other.subjectAlternativeNames) return false
        if (tags != other.tags) return false
        if (validationMethod != other.validationMethod) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acm.model.RequestCertificateRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the private certificate authority (CA) that will be used
         * to issue the certificate. If you do not provide an ARN and you are trying to request a private
         * certificate, ACM will attempt to issue a public certificate. For more information about
         * private CAs, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaWelcome.html">Amazon Web Services Certificate Manager Private Certificate Authority (PCA) user guide. The ARN must have the following form:
         *
         *
         * arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
         */
        var certificateAuthorityArn: kotlin.String? = null
        /**
         * Fully qualified domain name (FQDN), such as www.example.com, that you want to secure with
         * an ACM certificate. Use an asterisk (*) to create a wildcard certificate that protects
         * several sites in the same domain. For example, *.example.com protects www.example.com,
         * site.example.com, and images.example.com.
         *
         * The first domain name you enter cannot exceed 64 octets, including periods. Each
         * subsequent Subject Alternative Name (SAN), however, can be up to 253 octets in length.
         */
        var domainName: kotlin.String? = null
        /**
         * The domain name that you want ACM to use to send you emails so that you can validate
         * domain ownership.
         */
        var domainValidationOptions: List<DomainValidationOption>? = null
        /**
         * Customer chosen string that can be used to distinguish between calls to
         * RequestCertificate. Idempotency tokens time out after one hour. Therefore, if
         * you call RequestCertificate multiple times with the same idempotency token within
         * one hour, ACM recognizes that you are requesting only one certificate and will issue only
         * one. If you change the idempotency token for each call, ACM recognizes that you are
         * requesting multiple certificates.
         */
        var idempotencyToken: kotlin.String? = null
        /**
         * Currently, you can use this parameter to specify whether to add the certificate to a
         * certificate transparency log. Certificate transparency makes it possible to detect SSL/TLS
         * certificates that have been mistakenly or maliciously issued. Certificates that have not been
         * logged typically produce an error message in a browser. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-bestpractices.html#best-practices-transparency">Opting Out of Certificate Transparency Logging.
         */
        var options: aws.sdk.kotlin.services.acm.model.CertificateOptions? = null
        /**
         * Additional FQDNs to be included in the Subject Alternative Name extension of the ACM
         * certificate. For example, add the name www.example.net to a certificate for which the
         * DomainName field is www.example.com if users can reach your site by using
         * either name. The maximum number of domain names that you can add to an ACM certificate is
         * 100. However, the initial quota is 10 domain names. If you need more than 10 names, you must
         * request a quota increase. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-limits.html">Quotas.
         *
         * The maximum length of a SAN DNS name is 253 octets. The name is made up of multiple
         * labels separated by periods. No label can be longer than 63 octets. Consider the following
         * examples:
         *
         *
         *
         *
         * (63 octets).(63 octets).(63 octets).(61 octets) is legal because the
         * total length is 253 octets (63+1+63+1+63+1+61) and no label exceeds 63 octets.
         *
         *
         * (64 octets).(63 octets).(63 octets).(61 octets) is not legal because the
         * total length exceeds 253 octets (64+1+63+1+63+1+61) and the first label exceeds 63
         * octets.
         *
         *
         * (63 octets).(63 octets).(63 octets).(62 octets) is not legal because the
         * total length of the DNS name (63+1+63+1+63+1+62) exceeds 253 octets.
         */
        var subjectAlternativeNames: List<String>? = null
        /**
         * One or more resource tags to associate with the certificate.
         */
        var tags: List<Tag>? = null
        /**
         * The method you want to use if you are requesting a public certificate to validate that you
         * own or control domain. You can <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html">validate with DNS or <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-email.html">validate with
         * email. We recommend that you use DNS validation.
         */
        var validationMethod: aws.sdk.kotlin.services.acm.model.ValidationMethod? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acm.model.RequestCertificateRequest) : this() {
            this.certificateAuthorityArn = x.certificateAuthorityArn
            this.domainName = x.domainName
            this.domainValidationOptions = x.domainValidationOptions
            this.idempotencyToken = x.idempotencyToken
            this.options = x.options
            this.subjectAlternativeNames = x.subjectAlternativeNames
            this.tags = x.tags
            this.validationMethod = x.validationMethod
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acm.model.RequestCertificateRequest = RequestCertificateRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.acm.model.CertificateOptions] inside the given [block]
         */
        fun options(block: aws.sdk.kotlin.services.acm.model.CertificateOptions.Builder.() -> kotlin.Unit) {
            this.options = aws.sdk.kotlin.services.acm.model.CertificateOptions.invoke(block)
        }
    }
}
