// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.model



public class ResendValidationEmailRequest private constructor(builder: Builder) {
    /**
     * String that contains the ARN of the requested certificate. The certificate ARN is generated and returned by the RequestCertificate action as soon as the request is made. By default, using this parameter causes email to be sent to all top-level domains you specified in the certificate request. The ARN must be of the form:
     *
     * `arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012`
     */
    public val certificateArn: kotlin.String? = builder.certificateArn
    /**
     * The fully qualified domain name (FQDN) of the certificate that needs to be validated.
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * The base validation domain that will act as the suffix of the email addresses that are used to send the emails. This must be the same as the `Domain` value or a superdomain of the `Domain` value. For example, if you requested a certificate for `site.subdomain.example.com` and specify a **ValidationDomain** of `subdomain.example.com`, ACM sends email to the domain registrant, technical contact, and administrative contact in WHOIS and the following five addresses:
     * + admin@subdomain.example.com
     * + administrator@subdomain.example.com
     * + hostmaster@subdomain.example.com
     * + postmaster@subdomain.example.com
     * + webmaster@subdomain.example.com
     */
    public val validationDomain: kotlin.String? = builder.validationDomain

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acm.model.ResendValidationEmailRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResendValidationEmailRequest(")
        append("certificateArn=$certificateArn,")
        append("domain=$domain,")
        append("validationDomain=$validationDomain)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateArn?.hashCode() ?: 0
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (validationDomain?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResendValidationEmailRequest

        if (certificateArn != other.certificateArn) return false
        if (domain != other.domain) return false
        if (validationDomain != other.validationDomain) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acm.model.ResendValidationEmailRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * String that contains the ARN of the requested certificate. The certificate ARN is generated and returned by the RequestCertificate action as soon as the request is made. By default, using this parameter causes email to be sent to all top-level domains you specified in the certificate request. The ARN must be of the form:
         *
         * `arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012`
         */
        public var certificateArn: kotlin.String? = null
        /**
         * The fully qualified domain name (FQDN) of the certificate that needs to be validated.
         */
        public var domain: kotlin.String? = null
        /**
         * The base validation domain that will act as the suffix of the email addresses that are used to send the emails. This must be the same as the `Domain` value or a superdomain of the `Domain` value. For example, if you requested a certificate for `site.subdomain.example.com` and specify a **ValidationDomain** of `subdomain.example.com`, ACM sends email to the domain registrant, technical contact, and administrative contact in WHOIS and the following five addresses:
         * + admin@subdomain.example.com
         * + administrator@subdomain.example.com
         * + hostmaster@subdomain.example.com
         * + postmaster@subdomain.example.com
         * + webmaster@subdomain.example.com
         */
        public var validationDomain: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acm.model.ResendValidationEmailRequest) : this() {
            this.certificateArn = x.certificateArn
            this.domain = x.domain
            this.validationDomain = x.validationDomain
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acm.model.ResendValidationEmailRequest = ResendValidationEmailRequest(this)
    }
}
