// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.alexaforbusiness

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.alexaforbusiness.model.*
import aws.sdk.kotlin.services.alexaforbusiness.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "Alexa For Business"
public const val ServiceApiVersion: String = "2017-11-09"
public const val SdkVersion: String = "0.17.7-beta"

internal class DefaultAlexaForBusinessClient(override val config: AlexaForBusinessClient.Config) : AlexaForBusinessClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Associates a skill with the organization under the customer's AWS account. If a skill is private, the user implicitly accepts access to this skill during enablement.
     */
    override suspend fun approveSkill(input: ApproveSkillRequest): ApproveSkillResponse {
        val op = SdkHttpOperation.build<ApproveSkillRequest, ApproveSkillResponse> {
            serializer = ApproveSkillOperationSerializer()
            deserializer = ApproveSkillOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ApproveSkill"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates a contact with a given address book.
     */
    override suspend fun associateContactWithAddressBook(input: AssociateContactWithAddressBookRequest): AssociateContactWithAddressBookResponse {
        val op = SdkHttpOperation.build<AssociateContactWithAddressBookRequest, AssociateContactWithAddressBookResponse> {
            serializer = AssociateContactWithAddressBookOperationSerializer()
            deserializer = AssociateContactWithAddressBookOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateContactWithAddressBook"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates a device with the specified network profile.
     */
    override suspend fun associateDeviceWithNetworkProfile(input: AssociateDeviceWithNetworkProfileRequest): AssociateDeviceWithNetworkProfileResponse {
        val op = SdkHttpOperation.build<AssociateDeviceWithNetworkProfileRequest, AssociateDeviceWithNetworkProfileResponse> {
            serializer = AssociateDeviceWithNetworkProfileOperationSerializer()
            deserializer = AssociateDeviceWithNetworkProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateDeviceWithNetworkProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates a device with a given room. This applies all the settings from the room profile to the device, and all the skills in any skill groups added to that room. This operation requires the device to be online, or else a manual sync is required.
     */
    override suspend fun associateDeviceWithRoom(input: AssociateDeviceWithRoomRequest): AssociateDeviceWithRoomResponse {
        val op = SdkHttpOperation.build<AssociateDeviceWithRoomRequest, AssociateDeviceWithRoomResponse> {
            serializer = AssociateDeviceWithRoomOperationSerializer()
            deserializer = AssociateDeviceWithRoomOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateDeviceWithRoom"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates a skill group with a given room. This enables all skills in the associated skill group on all devices in the room.
     */
    override suspend fun associateSkillGroupWithRoom(input: AssociateSkillGroupWithRoomRequest): AssociateSkillGroupWithRoomResponse {
        val op = SdkHttpOperation.build<AssociateSkillGroupWithRoomRequest, AssociateSkillGroupWithRoomResponse> {
            serializer = AssociateSkillGroupWithRoomOperationSerializer()
            deserializer = AssociateSkillGroupWithRoomOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateSkillGroupWithRoom"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates a skill with a skill group.
     */
    override suspend fun associateSkillWithSkillGroup(input: AssociateSkillWithSkillGroupRequest): AssociateSkillWithSkillGroupResponse {
        val op = SdkHttpOperation.build<AssociateSkillWithSkillGroupRequest, AssociateSkillWithSkillGroupResponse> {
            serializer = AssociateSkillWithSkillGroupOperationSerializer()
            deserializer = AssociateSkillWithSkillGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateSkillWithSkillGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Makes a private skill available for enrolled users to enable on their devices.
     */
    override suspend fun associateSkillWithUsers(input: AssociateSkillWithUsersRequest): AssociateSkillWithUsersResponse {
        val op = SdkHttpOperation.build<AssociateSkillWithUsersRequest, AssociateSkillWithUsersResponse> {
            serializer = AssociateSkillWithUsersOperationSerializer()
            deserializer = AssociateSkillWithUsersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateSkillWithUsers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an address book with the specified details.
     */
    override suspend fun createAddressBook(input: CreateAddressBookRequest): CreateAddressBookResponse {
        val op = SdkHttpOperation.build<CreateAddressBookRequest, CreateAddressBookResponse> {
            serializer = CreateAddressBookOperationSerializer()
            deserializer = CreateAddressBookOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAddressBook"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a recurring schedule for usage reports to deliver to the specified S3 location with a specified daily or weekly interval.
     */
    override suspend fun createBusinessReportSchedule(input: CreateBusinessReportScheduleRequest): CreateBusinessReportScheduleResponse {
        val op = SdkHttpOperation.build<CreateBusinessReportScheduleRequest, CreateBusinessReportScheduleResponse> {
            serializer = CreateBusinessReportScheduleOperationSerializer()
            deserializer = CreateBusinessReportScheduleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateBusinessReportSchedule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds a new conference provider under the user's AWS account.
     */
    override suspend fun createConferenceProvider(input: CreateConferenceProviderRequest): CreateConferenceProviderResponse {
        val op = SdkHttpOperation.build<CreateConferenceProviderRequest, CreateConferenceProviderResponse> {
            serializer = CreateConferenceProviderOperationSerializer()
            deserializer = CreateConferenceProviderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateConferenceProvider"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a contact with the specified details.
     */
    override suspend fun createContact(input: CreateContactRequest): CreateContactResponse {
        val op = SdkHttpOperation.build<CreateContactRequest, CreateContactResponse> {
            serializer = CreateContactOperationSerializer()
            deserializer = CreateContactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateContact"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a gateway group with the specified details.
     */
    override suspend fun createGatewayGroup(input: CreateGatewayGroupRequest): CreateGatewayGroupResponse {
        val op = SdkHttpOperation.build<CreateGatewayGroupRequest, CreateGatewayGroupResponse> {
            serializer = CreateGatewayGroupOperationSerializer()
            deserializer = CreateGatewayGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateGatewayGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a network profile with the specified details.
     */
    override suspend fun createNetworkProfile(input: CreateNetworkProfileRequest): CreateNetworkProfileResponse {
        val op = SdkHttpOperation.build<CreateNetworkProfileRequest, CreateNetworkProfileResponse> {
            serializer = CreateNetworkProfileOperationSerializer()
            deserializer = CreateNetworkProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateNetworkProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new room profile with the specified details.
     */
    override suspend fun createProfile(input: CreateProfileRequest): CreateProfileResponse {
        val op = SdkHttpOperation.build<CreateProfileRequest, CreateProfileResponse> {
            serializer = CreateProfileOperationSerializer()
            deserializer = CreateProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a room with the specified details.
     */
    override suspend fun createRoom(input: CreateRoomRequest): CreateRoomResponse {
        val op = SdkHttpOperation.build<CreateRoomRequest, CreateRoomResponse> {
            serializer = CreateRoomOperationSerializer()
            deserializer = CreateRoomOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateRoom"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a skill group with a specified name and description.
     */
    override suspend fun createSkillGroup(input: CreateSkillGroupRequest): CreateSkillGroupResponse {
        val op = SdkHttpOperation.build<CreateSkillGroupRequest, CreateSkillGroupResponse> {
            serializer = CreateSkillGroupOperationSerializer()
            deserializer = CreateSkillGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSkillGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a user.
     */
    override suspend fun createUser(input: CreateUserRequest): CreateUserResponse {
        val op = SdkHttpOperation.build<CreateUserRequest, CreateUserResponse> {
            serializer = CreateUserOperationSerializer()
            deserializer = CreateUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an address book by the address book ARN.
     */
    override suspend fun deleteAddressBook(input: DeleteAddressBookRequest): DeleteAddressBookResponse {
        val op = SdkHttpOperation.build<DeleteAddressBookRequest, DeleteAddressBookResponse> {
            serializer = DeleteAddressBookOperationSerializer()
            deserializer = DeleteAddressBookOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAddressBook"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the recurring report delivery schedule with the specified schedule ARN.
     */
    override suspend fun deleteBusinessReportSchedule(input: DeleteBusinessReportScheduleRequest): DeleteBusinessReportScheduleResponse {
        val op = SdkHttpOperation.build<DeleteBusinessReportScheduleRequest, DeleteBusinessReportScheduleResponse> {
            serializer = DeleteBusinessReportScheduleOperationSerializer()
            deserializer = DeleteBusinessReportScheduleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteBusinessReportSchedule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a conference provider.
     */
    override suspend fun deleteConferenceProvider(input: DeleteConferenceProviderRequest): DeleteConferenceProviderResponse {
        val op = SdkHttpOperation.build<DeleteConferenceProviderRequest, DeleteConferenceProviderResponse> {
            serializer = DeleteConferenceProviderOperationSerializer()
            deserializer = DeleteConferenceProviderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteConferenceProvider"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a contact by the contact ARN.
     */
    override suspend fun deleteContact(input: DeleteContactRequest): DeleteContactResponse {
        val op = SdkHttpOperation.build<DeleteContactRequest, DeleteContactResponse> {
            serializer = DeleteContactOperationSerializer()
            deserializer = DeleteContactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteContact"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes a device from Alexa For Business.
     */
    override suspend fun deleteDevice(input: DeleteDeviceRequest): DeleteDeviceResponse {
        val op = SdkHttpOperation.build<DeleteDeviceRequest, DeleteDeviceResponse> {
            serializer = DeleteDeviceOperationSerializer()
            deserializer = DeleteDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDevice"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * When this action is called for a specified shared device, it allows authorized users to delete the device's entire previous history of voice input data and associated response data. This action can be called once every 24 hours for a specific shared device.
     */
    override suspend fun deleteDeviceUsageData(input: DeleteDeviceUsageDataRequest): DeleteDeviceUsageDataResponse {
        val op = SdkHttpOperation.build<DeleteDeviceUsageDataRequest, DeleteDeviceUsageDataResponse> {
            serializer = DeleteDeviceUsageDataOperationSerializer()
            deserializer = DeleteDeviceUsageDataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDeviceUsageData"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a gateway group.
     */
    override suspend fun deleteGatewayGroup(input: DeleteGatewayGroupRequest): DeleteGatewayGroupResponse {
        val op = SdkHttpOperation.build<DeleteGatewayGroupRequest, DeleteGatewayGroupResponse> {
            serializer = DeleteGatewayGroupOperationSerializer()
            deserializer = DeleteGatewayGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteGatewayGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a network profile by the network profile ARN.
     */
    override suspend fun deleteNetworkProfile(input: DeleteNetworkProfileRequest): DeleteNetworkProfileResponse {
        val op = SdkHttpOperation.build<DeleteNetworkProfileRequest, DeleteNetworkProfileResponse> {
            serializer = DeleteNetworkProfileOperationSerializer()
            deserializer = DeleteNetworkProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteNetworkProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a room profile by the profile ARN.
     */
    override suspend fun deleteProfile(input: DeleteProfileRequest): DeleteProfileResponse {
        val op = SdkHttpOperation.build<DeleteProfileRequest, DeleteProfileResponse> {
            serializer = DeleteProfileOperationSerializer()
            deserializer = DeleteProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a room by the room ARN.
     */
    override suspend fun deleteRoom(input: DeleteRoomRequest): DeleteRoomResponse {
        val op = SdkHttpOperation.build<DeleteRoomRequest, DeleteRoomResponse> {
            serializer = DeleteRoomOperationSerializer()
            deserializer = DeleteRoomOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteRoom"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes room skill parameter details by room, skill, and parameter key ID.
     */
    override suspend fun deleteRoomSkillParameter(input: DeleteRoomSkillParameterRequest): DeleteRoomSkillParameterResponse {
        val op = SdkHttpOperation.build<DeleteRoomSkillParameterRequest, DeleteRoomSkillParameterResponse> {
            serializer = DeleteRoomSkillParameterOperationSerializer()
            deserializer = DeleteRoomSkillParameterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteRoomSkillParameter"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Unlinks a third-party account from a skill.
     */
    override suspend fun deleteSkillAuthorization(input: DeleteSkillAuthorizationRequest): DeleteSkillAuthorizationResponse {
        val op = SdkHttpOperation.build<DeleteSkillAuthorizationRequest, DeleteSkillAuthorizationResponse> {
            serializer = DeleteSkillAuthorizationOperationSerializer()
            deserializer = DeleteSkillAuthorizationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSkillAuthorization"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a skill group by skill group ARN.
     */
    override suspend fun deleteSkillGroup(input: DeleteSkillGroupRequest): DeleteSkillGroupResponse {
        val op = SdkHttpOperation.build<DeleteSkillGroupRequest, DeleteSkillGroupResponse> {
            serializer = DeleteSkillGroupOperationSerializer()
            deserializer = DeleteSkillGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSkillGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a specified user by user ARN and enrollment ARN.
     */
    override suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse {
        val op = SdkHttpOperation.build<DeleteUserRequest, DeleteUserResponse> {
            serializer = DeleteUserOperationSerializer()
            deserializer = DeleteUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a contact from a given address book.
     */
    override suspend fun disassociateContactFromAddressBook(input: DisassociateContactFromAddressBookRequest): DisassociateContactFromAddressBookResponse {
        val op = SdkHttpOperation.build<DisassociateContactFromAddressBookRequest, DisassociateContactFromAddressBookResponse> {
            serializer = DisassociateContactFromAddressBookOperationSerializer()
            deserializer = DisassociateContactFromAddressBookOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateContactFromAddressBook"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a device from its current room. The device continues to be connected to the Wi-Fi network and is still registered to the account. The device settings and skills are removed from the room.
     */
    override suspend fun disassociateDeviceFromRoom(input: DisassociateDeviceFromRoomRequest): DisassociateDeviceFromRoomResponse {
        val op = SdkHttpOperation.build<DisassociateDeviceFromRoomRequest, DisassociateDeviceFromRoomResponse> {
            serializer = DisassociateDeviceFromRoomOperationSerializer()
            deserializer = DisassociateDeviceFromRoomOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateDeviceFromRoom"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a skill from a skill group.
     */
    override suspend fun disassociateSkillFromSkillGroup(input: DisassociateSkillFromSkillGroupRequest): DisassociateSkillFromSkillGroupResponse {
        val op = SdkHttpOperation.build<DisassociateSkillFromSkillGroupRequest, DisassociateSkillFromSkillGroupResponse> {
            serializer = DisassociateSkillFromSkillGroupOperationSerializer()
            deserializer = DisassociateSkillFromSkillGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateSkillFromSkillGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Makes a private skill unavailable for enrolled users and prevents them from enabling it on their devices.
     */
    override suspend fun disassociateSkillFromUsers(input: DisassociateSkillFromUsersRequest): DisassociateSkillFromUsersResponse {
        val op = SdkHttpOperation.build<DisassociateSkillFromUsersRequest, DisassociateSkillFromUsersResponse> {
            serializer = DisassociateSkillFromUsersOperationSerializer()
            deserializer = DisassociateSkillFromUsersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateSkillFromUsers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a skill group from a specified room. This disables all skills in the skill group on all devices in the room.
     */
    override suspend fun disassociateSkillGroupFromRoom(input: DisassociateSkillGroupFromRoomRequest): DisassociateSkillGroupFromRoomResponse {
        val op = SdkHttpOperation.build<DisassociateSkillGroupFromRoomRequest, DisassociateSkillGroupFromRoomResponse> {
            serializer = DisassociateSkillGroupFromRoomOperationSerializer()
            deserializer = DisassociateSkillGroupFromRoomOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateSkillGroupFromRoom"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Forgets smart home appliances associated to a room.
     */
    override suspend fun forgetSmartHomeAppliances(input: ForgetSmartHomeAppliancesRequest): ForgetSmartHomeAppliancesResponse {
        val op = SdkHttpOperation.build<ForgetSmartHomeAppliancesRequest, ForgetSmartHomeAppliancesResponse> {
            serializer = ForgetSmartHomeAppliancesOperationSerializer()
            deserializer = ForgetSmartHomeAppliancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ForgetSmartHomeAppliances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets address the book details by the address book ARN.
     */
    override suspend fun getAddressBook(input: GetAddressBookRequest): GetAddressBookResponse {
        val op = SdkHttpOperation.build<GetAddressBookRequest, GetAddressBookResponse> {
            serializer = GetAddressBookOperationSerializer()
            deserializer = GetAddressBookOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAddressBook"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the existing conference preferences.
     */
    override suspend fun getConferencePreference(input: GetConferencePreferenceRequest): GetConferencePreferenceResponse {
        val op = SdkHttpOperation.build<GetConferencePreferenceRequest, GetConferencePreferenceResponse> {
            serializer = GetConferencePreferenceOperationSerializer()
            deserializer = GetConferencePreferenceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetConferencePreference"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets details about a specific conference provider.
     */
    override suspend fun getConferenceProvider(input: GetConferenceProviderRequest): GetConferenceProviderResponse {
        val op = SdkHttpOperation.build<GetConferenceProviderRequest, GetConferenceProviderResponse> {
            serializer = GetConferenceProviderOperationSerializer()
            deserializer = GetConferenceProviderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetConferenceProvider"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the contact details by the contact ARN.
     */
    override suspend fun getContact(input: GetContactRequest): GetContactResponse {
        val op = SdkHttpOperation.build<GetContactRequest, GetContactResponse> {
            serializer = GetContactOperationSerializer()
            deserializer = GetContactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetContact"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the details of a device by device ARN.
     */
    override suspend fun getDevice(input: GetDeviceRequest): GetDeviceResponse {
        val op = SdkHttpOperation.build<GetDeviceRequest, GetDeviceResponse> {
            serializer = GetDeviceOperationSerializer()
            deserializer = GetDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDevice"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the details of a gateway.
     */
    override suspend fun getGateway(input: GetGatewayRequest): GetGatewayResponse {
        val op = SdkHttpOperation.build<GetGatewayRequest, GetGatewayResponse> {
            serializer = GetGatewayOperationSerializer()
            deserializer = GetGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetGateway"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the details of a gateway group.
     */
    override suspend fun getGatewayGroup(input: GetGatewayGroupRequest): GetGatewayGroupResponse {
        val op = SdkHttpOperation.build<GetGatewayGroupRequest, GetGatewayGroupResponse> {
            serializer = GetGatewayGroupOperationSerializer()
            deserializer = GetGatewayGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetGatewayGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the configured values for the user enrollment invitation email template.
     */
    override suspend fun getInvitationConfiguration(input: GetInvitationConfigurationRequest): GetInvitationConfigurationResponse {
        val op = SdkHttpOperation.build<GetInvitationConfigurationRequest, GetInvitationConfigurationResponse> {
            serializer = GetInvitationConfigurationOperationSerializer()
            deserializer = GetInvitationConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetInvitationConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the network profile details by the network profile ARN.
     */
    override suspend fun getNetworkProfile(input: GetNetworkProfileRequest): GetNetworkProfileResponse {
        val op = SdkHttpOperation.build<GetNetworkProfileRequest, GetNetworkProfileResponse> {
            serializer = GetNetworkProfileOperationSerializer()
            deserializer = GetNetworkProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetNetworkProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the details of a room profile by profile ARN.
     */
    override suspend fun getProfile(input: GetProfileRequest): GetProfileResponse {
        val op = SdkHttpOperation.build<GetProfileRequest, GetProfileResponse> {
            serializer = GetProfileOperationSerializer()
            deserializer = GetProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets room details by room ARN.
     */
    override suspend fun getRoom(input: GetRoomRequest): GetRoomResponse {
        val op = SdkHttpOperation.build<GetRoomRequest, GetRoomResponse> {
            serializer = GetRoomOperationSerializer()
            deserializer = GetRoomOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRoom"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets room skill parameter details by room, skill, and parameter key ARN.
     */
    override suspend fun getRoomSkillParameter(input: GetRoomSkillParameterRequest): GetRoomSkillParameterResponse {
        val op = SdkHttpOperation.build<GetRoomSkillParameterRequest, GetRoomSkillParameterResponse> {
            serializer = GetRoomSkillParameterOperationSerializer()
            deserializer = GetRoomSkillParameterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRoomSkillParameter"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets skill group details by skill group ARN.
     */
    override suspend fun getSkillGroup(input: GetSkillGroupRequest): GetSkillGroupResponse {
        val op = SdkHttpOperation.build<GetSkillGroupRequest, GetSkillGroupResponse> {
            serializer = GetSkillGroupOperationSerializer()
            deserializer = GetSkillGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSkillGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the details of the schedules that a user configured. A download URL of the report associated with each schedule is returned every time this action is called. A new download URL is returned each time, and is valid for 24 hours.
     */
    override suspend fun listBusinessReportSchedules(input: ListBusinessReportSchedulesRequest): ListBusinessReportSchedulesResponse {
        val op = SdkHttpOperation.build<ListBusinessReportSchedulesRequest, ListBusinessReportSchedulesResponse> {
            serializer = ListBusinessReportSchedulesOperationSerializer()
            deserializer = ListBusinessReportSchedulesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListBusinessReportSchedules"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists conference providers under a specific AWS account.
     */
    override suspend fun listConferenceProviders(input: ListConferenceProvidersRequest): ListConferenceProvidersResponse {
        val op = SdkHttpOperation.build<ListConferenceProvidersRequest, ListConferenceProvidersResponse> {
            serializer = ListConferenceProvidersOperationSerializer()
            deserializer = ListConferenceProvidersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListConferenceProviders"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the device event history, including device connection status, for up to 30 days.
     */
    override suspend fun listDeviceEvents(input: ListDeviceEventsRequest): ListDeviceEventsResponse {
        val op = SdkHttpOperation.build<ListDeviceEventsRequest, ListDeviceEventsResponse> {
            serializer = ListDeviceEventsOperationSerializer()
            deserializer = ListDeviceEventsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDeviceEvents"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of gateway group summaries. Use GetGatewayGroup to retrieve details of a specific gateway group.
     */
    override suspend fun listGatewayGroups(input: ListGatewayGroupsRequest): ListGatewayGroupsResponse {
        val op = SdkHttpOperation.build<ListGatewayGroupsRequest, ListGatewayGroupsResponse> {
            serializer = ListGatewayGroupsOperationSerializer()
            deserializer = ListGatewayGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListGatewayGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of gateway summaries. Use GetGateway to retrieve details of a specific gateway. An optional gateway group ARN can be provided to only retrieve gateway summaries of gateways that are associated with that gateway group ARN.
     */
    override suspend fun listGateways(input: ListGatewaysRequest): ListGatewaysResponse {
        val op = SdkHttpOperation.build<ListGatewaysRequest, ListGatewaysResponse> {
            serializer = ListGatewaysOperationSerializer()
            deserializer = ListGatewaysOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListGateways"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all enabled skills in a specific skill group.
     */
    override suspend fun listSkills(input: ListSkillsRequest): ListSkillsResponse {
        val op = SdkHttpOperation.build<ListSkillsRequest, ListSkillsResponse> {
            serializer = ListSkillsOperationSerializer()
            deserializer = ListSkillsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSkills"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all categories in the Alexa skill store.
     */
    override suspend fun listSkillsStoreCategories(input: ListSkillsStoreCategoriesRequest): ListSkillsStoreCategoriesResponse {
        val op = SdkHttpOperation.build<ListSkillsStoreCategoriesRequest, ListSkillsStoreCategoriesResponse> {
            serializer = ListSkillsStoreCategoriesOperationSerializer()
            deserializer = ListSkillsStoreCategoriesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSkillsStoreCategories"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all skills in the Alexa skill store by category.
     */
    override suspend fun listSkillsStoreSkillsByCategory(input: ListSkillsStoreSkillsByCategoryRequest): ListSkillsStoreSkillsByCategoryResponse {
        val op = SdkHttpOperation.build<ListSkillsStoreSkillsByCategoryRequest, ListSkillsStoreSkillsByCategoryResponse> {
            serializer = ListSkillsStoreSkillsByCategoryOperationSerializer()
            deserializer = ListSkillsStoreSkillsByCategoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSkillsStoreSkillsByCategory"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all of the smart home appliances associated with a room.
     */
    override suspend fun listSmartHomeAppliances(input: ListSmartHomeAppliancesRequest): ListSmartHomeAppliancesResponse {
        val op = SdkHttpOperation.build<ListSmartHomeAppliancesRequest, ListSmartHomeAppliancesResponse> {
            serializer = ListSmartHomeAppliancesOperationSerializer()
            deserializer = ListSmartHomeAppliancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSmartHomeAppliances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all tags for the specified resource.
     */
    override suspend fun listTags(input: ListTagsRequest): ListTagsResponse {
        val op = SdkHttpOperation.build<ListTagsRequest, ListTagsResponse> {
            serializer = ListTagsOperationSerializer()
            deserializer = ListTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sets the conference preferences on a specific conference provider at the account level.
     */
    override suspend fun putConferencePreference(input: PutConferencePreferenceRequest): PutConferencePreferenceResponse {
        val op = SdkHttpOperation.build<PutConferencePreferenceRequest, PutConferencePreferenceResponse> {
            serializer = PutConferencePreferenceOperationSerializer()
            deserializer = PutConferencePreferenceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutConferencePreference"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Configures the email template for the user enrollment invitation with the specified attributes.
     */
    override suspend fun putInvitationConfiguration(input: PutInvitationConfigurationRequest): PutInvitationConfigurationResponse {
        val op = SdkHttpOperation.build<PutInvitationConfigurationRequest, PutInvitationConfigurationResponse> {
            serializer = PutInvitationConfigurationOperationSerializer()
            deserializer = PutInvitationConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutInvitationConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates room skill parameter details by room, skill, and parameter key ID. Not all skills have a room skill parameter.
     */
    override suspend fun putRoomSkillParameter(input: PutRoomSkillParameterRequest): PutRoomSkillParameterResponse {
        val op = SdkHttpOperation.build<PutRoomSkillParameterRequest, PutRoomSkillParameterResponse> {
            serializer = PutRoomSkillParameterOperationSerializer()
            deserializer = PutRoomSkillParameterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutRoomSkillParameter"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Links a user's account to a third-party skill provider. If this API operation is called by an assumed IAM role, the skill being linked must be a private skill. Also, the skill must be owned by the AWS account that assumed the IAM role.
     */
    override suspend fun putSkillAuthorization(input: PutSkillAuthorizationRequest): PutSkillAuthorizationResponse {
        val op = SdkHttpOperation.build<PutSkillAuthorizationRequest, PutSkillAuthorizationResponse> {
            serializer = PutSkillAuthorizationOperationSerializer()
            deserializer = PutSkillAuthorizationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutSkillAuthorization"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Registers an Alexa-enabled device built by an Original Equipment Manufacturer (OEM) using Alexa Voice Service (AVS).
     */
    override suspend fun registerAvsDevice(input: RegisterAvsDeviceRequest): RegisterAvsDeviceResponse {
        val op = SdkHttpOperation.build<RegisterAvsDeviceRequest, RegisterAvsDeviceResponse> {
            serializer = RegisterAVSDeviceOperationSerializer()
            deserializer = RegisterAVSDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterAVSDevice"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a skill from the organization under a user's AWS account. If the skill is a private skill, it moves to an AcceptStatus of PENDING. Any private or public skill that is rejected can be added later by calling the ApproveSkill API.
     */
    override suspend fun rejectSkill(input: RejectSkillRequest): RejectSkillResponse {
        val op = SdkHttpOperation.build<RejectSkillRequest, RejectSkillResponse> {
            serializer = RejectSkillOperationSerializer()
            deserializer = RejectSkillOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RejectSkill"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Determines the details for the room from which a skill request was invoked. This operation is used by skill developers.
     *
     * To query ResolveRoom from an Alexa skill, the skill ID needs to be authorized. When the skill is using an AWS Lambda function, the skill is automatically authorized when you publish your skill as a private skill to your AWS account. Skills that are hosted using a custom web service must be manually authorized. To get your skill authorized, contact AWS Support with your AWS account ID that queries the ResolveRoom API and skill ID.
     */
    override suspend fun resolveRoom(input: ResolveRoomRequest): ResolveRoomResponse {
        val op = SdkHttpOperation.build<ResolveRoomRequest, ResolveRoomResponse> {
            serializer = ResolveRoomOperationSerializer()
            deserializer = ResolveRoomOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ResolveRoom"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Revokes an invitation and invalidates the enrollment URL.
     */
    override suspend fun revokeInvitation(input: RevokeInvitationRequest): RevokeInvitationResponse {
        val op = SdkHttpOperation.build<RevokeInvitationRequest, RevokeInvitationResponse> {
            serializer = RevokeInvitationOperationSerializer()
            deserializer = RevokeInvitationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RevokeInvitation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Searches address books and lists the ones that meet a set of filter and sort criteria.
     */
    override suspend fun searchAddressBooks(input: SearchAddressBooksRequest): SearchAddressBooksResponse {
        val op = SdkHttpOperation.build<SearchAddressBooksRequest, SearchAddressBooksResponse> {
            serializer = SearchAddressBooksOperationSerializer()
            deserializer = SearchAddressBooksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchAddressBooks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Searches contacts and lists the ones that meet a set of filter and sort criteria.
     */
    override suspend fun searchContacts(input: SearchContactsRequest): SearchContactsResponse {
        val op = SdkHttpOperation.build<SearchContactsRequest, SearchContactsResponse> {
            serializer = SearchContactsOperationSerializer()
            deserializer = SearchContactsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchContacts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Searches devices and lists the ones that meet a set of filter criteria.
     */
    override suspend fun searchDevices(input: SearchDevicesRequest): SearchDevicesResponse {
        val op = SdkHttpOperation.build<SearchDevicesRequest, SearchDevicesResponse> {
            serializer = SearchDevicesOperationSerializer()
            deserializer = SearchDevicesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchDevices"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Searches network profiles and lists the ones that meet a set of filter and sort criteria.
     */
    override suspend fun searchNetworkProfiles(input: SearchNetworkProfilesRequest): SearchNetworkProfilesResponse {
        val op = SdkHttpOperation.build<SearchNetworkProfilesRequest, SearchNetworkProfilesResponse> {
            serializer = SearchNetworkProfilesOperationSerializer()
            deserializer = SearchNetworkProfilesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchNetworkProfiles"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Searches room profiles and lists the ones that meet a set of filter criteria.
     */
    override suspend fun searchProfiles(input: SearchProfilesRequest): SearchProfilesResponse {
        val op = SdkHttpOperation.build<SearchProfilesRequest, SearchProfilesResponse> {
            serializer = SearchProfilesOperationSerializer()
            deserializer = SearchProfilesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchProfiles"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Searches rooms and lists the ones that meet a set of filter and sort criteria.
     */
    override suspend fun searchRooms(input: SearchRoomsRequest): SearchRoomsResponse {
        val op = SdkHttpOperation.build<SearchRoomsRequest, SearchRoomsResponse> {
            serializer = SearchRoomsOperationSerializer()
            deserializer = SearchRoomsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchRooms"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Searches skill groups and lists the ones that meet a set of filter and sort criteria.
     */
    override suspend fun searchSkillGroups(input: SearchSkillGroupsRequest): SearchSkillGroupsResponse {
        val op = SdkHttpOperation.build<SearchSkillGroupsRequest, SearchSkillGroupsResponse> {
            serializer = SearchSkillGroupsOperationSerializer()
            deserializer = SearchSkillGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchSkillGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Searches users and lists the ones that meet a set of filter and sort criteria.
     */
    override suspend fun searchUsers(input: SearchUsersRequest): SearchUsersResponse {
        val op = SdkHttpOperation.build<SearchUsersRequest, SearchUsersResponse> {
            serializer = SearchUsersOperationSerializer()
            deserializer = SearchUsersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchUsers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Triggers an asynchronous flow to send text, SSML, or audio announcements to rooms that are identified by a search or filter.
     */
    override suspend fun sendAnnouncement(input: SendAnnouncementRequest): SendAnnouncementResponse {
        val op = SdkHttpOperation.build<SendAnnouncementRequest, SendAnnouncementResponse> {
            serializer = SendAnnouncementOperationSerializer()
            deserializer = SendAnnouncementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SendAnnouncement"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sends an enrollment invitation email with a URL to a user. The URL is valid for 30 days or until you call this operation again, whichever comes first.
     */
    override suspend fun sendInvitation(input: SendInvitationRequest): SendInvitationResponse {
        val op = SdkHttpOperation.build<SendInvitationRequest, SendInvitationResponse> {
            serializer = SendInvitationOperationSerializer()
            deserializer = SendInvitationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SendInvitation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Resets a device and its account to the known default settings. This clears all information and settings set by previous users in the following ways:
     * + Bluetooth - This unpairs all bluetooth devices paired with your echo device.
     * + Volume - This resets the echo device's volume to the default value.
     * + Notifications - This clears all notifications from your echo device.
     * + Lists - This clears all to-do items from your echo device.
     * + Settings - This internally syncs the room's profile (if the device is assigned to a room), contacts, address books, delegation access for account linking, and communications (if enabled on the room profile).
     */
    override suspend fun startDeviceSync(input: StartDeviceSyncRequest): StartDeviceSyncResponse {
        val op = SdkHttpOperation.build<StartDeviceSyncRequest, StartDeviceSyncResponse> {
            serializer = StartDeviceSyncOperationSerializer()
            deserializer = StartDeviceSyncOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartDeviceSync"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Initiates the discovery of any smart home appliances associated with the room.
     */
    override suspend fun startSmartHomeApplianceDiscovery(input: StartSmartHomeApplianceDiscoveryRequest): StartSmartHomeApplianceDiscoveryResponse {
        val op = SdkHttpOperation.build<StartSmartHomeApplianceDiscoveryRequest, StartSmartHomeApplianceDiscoveryResponse> {
            serializer = StartSmartHomeApplianceDiscoveryOperationSerializer()
            deserializer = StartSmartHomeApplianceDiscoveryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartSmartHomeApplianceDiscovery"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds metadata tags to a specified resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes metadata tags from a specified resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates address book details by the address book ARN.
     */
    override suspend fun updateAddressBook(input: UpdateAddressBookRequest): UpdateAddressBookResponse {
        val op = SdkHttpOperation.build<UpdateAddressBookRequest, UpdateAddressBookResponse> {
            serializer = UpdateAddressBookOperationSerializer()
            deserializer = UpdateAddressBookOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAddressBook"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the configuration of the report delivery schedule with the specified schedule ARN.
     */
    override suspend fun updateBusinessReportSchedule(input: UpdateBusinessReportScheduleRequest): UpdateBusinessReportScheduleResponse {
        val op = SdkHttpOperation.build<UpdateBusinessReportScheduleRequest, UpdateBusinessReportScheduleResponse> {
            serializer = UpdateBusinessReportScheduleOperationSerializer()
            deserializer = UpdateBusinessReportScheduleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateBusinessReportSchedule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing conference provider's settings.
     */
    override suspend fun updateConferenceProvider(input: UpdateConferenceProviderRequest): UpdateConferenceProviderResponse {
        val op = SdkHttpOperation.build<UpdateConferenceProviderRequest, UpdateConferenceProviderResponse> {
            serializer = UpdateConferenceProviderOperationSerializer()
            deserializer = UpdateConferenceProviderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateConferenceProvider"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the contact details by the contact ARN.
     */
    override suspend fun updateContact(input: UpdateContactRequest): UpdateContactResponse {
        val op = SdkHttpOperation.build<UpdateContactRequest, UpdateContactResponse> {
            serializer = UpdateContactOperationSerializer()
            deserializer = UpdateContactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateContact"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the device name by device ARN.
     */
    override suspend fun updateDevice(input: UpdateDeviceRequest): UpdateDeviceResponse {
        val op = SdkHttpOperation.build<UpdateDeviceRequest, UpdateDeviceResponse> {
            serializer = UpdateDeviceOperationSerializer()
            deserializer = UpdateDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDevice"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the details of a gateway. If any optional field is not provided, the existing corresponding value is left unmodified.
     */
    override suspend fun updateGateway(input: UpdateGatewayRequest): UpdateGatewayResponse {
        val op = SdkHttpOperation.build<UpdateGatewayRequest, UpdateGatewayResponse> {
            serializer = UpdateGatewayOperationSerializer()
            deserializer = UpdateGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateGateway"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the details of a gateway group. If any optional field is not provided, the existing corresponding value is left unmodified.
     */
    override suspend fun updateGatewayGroup(input: UpdateGatewayGroupRequest): UpdateGatewayGroupResponse {
        val op = SdkHttpOperation.build<UpdateGatewayGroupRequest, UpdateGatewayGroupResponse> {
            serializer = UpdateGatewayGroupOperationSerializer()
            deserializer = UpdateGatewayGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateGatewayGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a network profile by the network profile ARN.
     */
    override suspend fun updateNetworkProfile(input: UpdateNetworkProfileRequest): UpdateNetworkProfileResponse {
        val op = SdkHttpOperation.build<UpdateNetworkProfileRequest, UpdateNetworkProfileResponse> {
            serializer = UpdateNetworkProfileOperationSerializer()
            deserializer = UpdateNetworkProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateNetworkProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing room profile by room profile ARN.
     */
    override suspend fun updateProfile(input: UpdateProfileRequest): UpdateProfileResponse {
        val op = SdkHttpOperation.build<UpdateProfileRequest, UpdateProfileResponse> {
            serializer = UpdateProfileOperationSerializer()
            deserializer = UpdateProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates room details by room ARN.
     */
    override suspend fun updateRoom(input: UpdateRoomRequest): UpdateRoomResponse {
        val op = SdkHttpOperation.build<UpdateRoomRequest, UpdateRoomResponse> {
            serializer = UpdateRoomOperationSerializer()
            deserializer = UpdateRoomOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateRoom"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates skill group details by skill group ARN.
     */
    override suspend fun updateSkillGroup(input: UpdateSkillGroupRequest): UpdateSkillGroupResponse {
        val op = SdkHttpOperation.build<UpdateSkillGroupRequest, UpdateSkillGroupResponse> {
            serializer = UpdateSkillGroupOperationSerializer()
            deserializer = UpdateSkillGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSkillGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "a4b"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "a4b")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
