// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.alexaforbusiness.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.alexaforbusiness.model.AlexaForBusinessException
import aws.sdk.kotlin.services.alexaforbusiness.model.CreateConferenceProviderResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateConferenceProviderOperationDeserializer: HttpDeserialize<CreateConferenceProviderResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateConferenceProviderResponse {
        if (!response.status.isSuccess()) {
            throwCreateConferenceProviderError(context, response)
        }
        val builder = CreateConferenceProviderResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateConferenceProviderOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateConferenceProviderError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw AlexaForBusinessException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AlreadyExistsException" -> AlreadyExistsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> AlexaForBusinessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateConferenceProviderOperationBody(builder: CreateConferenceProviderResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONFERENCEPROVIDERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ConferenceProviderArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONFERENCEPROVIDERARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONFERENCEPROVIDERARN_DESCRIPTOR.index -> builder.conferenceProviderArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
