// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.alexaforbusiness.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.alexaforbusiness.model.AlexaForBusinessException
import aws.sdk.kotlin.services.alexaforbusiness.model.BusinessReportSchedule
import aws.sdk.kotlin.services.alexaforbusiness.model.ListBusinessReportSchedulesResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListBusinessReportSchedulesOperationDeserializer: HttpDeserialize<ListBusinessReportSchedulesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListBusinessReportSchedulesResponse {
        if (!response.status.isSuccess()) {
            throwListBusinessReportSchedulesError(context, response)
        }
        val builder = ListBusinessReportSchedulesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListBusinessReportSchedulesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListBusinessReportSchedulesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw AlexaForBusinessException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> AlexaForBusinessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListBusinessReportSchedulesOperationBody(builder: ListBusinessReportSchedulesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BUSINESSREPORTSCHEDULES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("BusinessReportSchedules"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BUSINESSREPORTSCHEDULES_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BUSINESSREPORTSCHEDULES_DESCRIPTOR.index -> builder.businessReportSchedules =
                    deserializer.deserializeList(BUSINESSREPORTSCHEDULES_DESCRIPTOR) {
                        val col0 = mutableListOf<BusinessReportSchedule>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBusinessReportScheduleDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
