// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.alexaforbusiness.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.alexaforbusiness.model.AlexaForBusinessException
import aws.sdk.kotlin.services.alexaforbusiness.model.ResolveRoomResponse
import aws.sdk.kotlin.services.alexaforbusiness.model.RoomSkillParameter
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ResolveRoomOperationDeserializer: HttpDeserialize<ResolveRoomResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ResolveRoomResponse {
        if (!response.status.isSuccess()) {
            throwResolveRoomError(context, response)
        }
        val builder = ResolveRoomResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeResolveRoomOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwResolveRoomError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw AlexaForBusinessException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> AlexaForBusinessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeResolveRoomOperationBody(builder: ResolveRoomResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ROOMARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoomArn"))
    val ROOMNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoomName"))
    val ROOMSKILLPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("RoomSkillParameters"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ROOMARN_DESCRIPTOR)
        field(ROOMNAME_DESCRIPTOR)
        field(ROOMSKILLPARAMETERS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ROOMARN_DESCRIPTOR.index -> builder.roomArn = deserializeString()
                ROOMNAME_DESCRIPTOR.index -> builder.roomName = deserializeString()
                ROOMSKILLPARAMETERS_DESCRIPTOR.index -> builder.roomSkillParameters =
                    deserializer.deserializeList(ROOMSKILLPARAMETERS_DESCRIPTOR) {
                        val col0 = mutableListOf<RoomSkillParameter>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRoomSkillParameterDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
