// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.alexaforbusiness.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.alexaforbusiness.model.AlexaForBusinessException
import aws.sdk.kotlin.services.alexaforbusiness.model.DeviceData
import aws.sdk.kotlin.services.alexaforbusiness.model.SearchDevicesResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class SearchDevicesOperationDeserializer: HttpDeserialize<SearchDevicesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): SearchDevicesResponse {
        if (!response.status.isSuccess()) {
            throwSearchDevicesError(context, response)
        }
        val builder = SearchDevicesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeSearchDevicesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwSearchDevicesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw AlexaForBusinessException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> AlexaForBusinessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeSearchDevicesOperationBody(builder: SearchDevicesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DEVICES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Devices"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val TOTALCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("TotalCount"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEVICES_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(TOTALCOUNT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DEVICES_DESCRIPTOR.index -> builder.devices =
                    deserializer.deserializeList(DEVICES_DESCRIPTOR) {
                        val col0 = mutableListOf<DeviceData>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDeviceDataDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                TOTALCOUNT_DESCRIPTOR.index -> builder.totalCount = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
