// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplifyuibuilder

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.amplifyuibuilder.model.*
import aws.sdk.kotlin.services.amplifyuibuilder.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "AmplifyUIBuilder"
public const val ServiceApiVersion: String = "2021-08-11"
public const val SdkVersion: String = "0.17.1-beta"

internal class DefaultAmplifyUiBuilderClient(override val config: AmplifyUiBuilderClient.Config) : AmplifyUiBuilderClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Creates a new component for an Amplify app.
     */
    override suspend fun createComponent(input: CreateComponentRequest): CreateComponentResponse {
        val op = SdkHttpOperation.build<CreateComponentRequest, CreateComponentResponse> {
            serializer = CreateComponentOperationSerializer()
            deserializer = CreateComponentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateComponent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplifyuibuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a theme to apply to the components in an Amplify app.
     */
    override suspend fun createTheme(input: CreateThemeRequest): CreateThemeResponse {
        val op = SdkHttpOperation.build<CreateThemeRequest, CreateThemeResponse> {
            serializer = CreateThemeOperationSerializer()
            deserializer = CreateThemeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTheme"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplifyuibuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a component from an Amplify app.
     */
    override suspend fun deleteComponent(input: DeleteComponentRequest): DeleteComponentResponse {
        val op = SdkHttpOperation.build<DeleteComponentRequest, DeleteComponentResponse> {
            serializer = DeleteComponentOperationSerializer()
            deserializer = DeleteComponentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteComponent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplifyuibuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a theme from an Amplify app.
     */
    override suspend fun deleteTheme(input: DeleteThemeRequest): DeleteThemeResponse {
        val op = SdkHttpOperation.build<DeleteThemeRequest, DeleteThemeResponse> {
            serializer = DeleteThemeOperationSerializer()
            deserializer = DeleteThemeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTheme"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplifyuibuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Exchanges an access code for a token.
     */
    override suspend fun exchangeCodeForToken(input: ExchangeCodeForTokenRequest): ExchangeCodeForTokenResponse {
        val op = SdkHttpOperation.build<ExchangeCodeForTokenRequest, ExchangeCodeForTokenResponse> {
            serializer = ExchangeCodeForTokenOperationSerializer()
            deserializer = ExchangeCodeForTokenOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ExchangeCodeForToken"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplifyuibuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Exports component configurations to code that is ready to integrate into an Amplify app.
     */
    override suspend fun exportComponents(input: ExportComponentsRequest): ExportComponentsResponse {
        val op = SdkHttpOperation.build<ExportComponentsRequest, ExportComponentsResponse> {
            serializer = ExportComponentsOperationSerializer()
            deserializer = ExportComponentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ExportComponents"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplifyuibuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Exports theme configurations to code that is ready to integrate into an Amplify app.
     */
    override suspend fun exportThemes(input: ExportThemesRequest): ExportThemesResponse {
        val op = SdkHttpOperation.build<ExportThemesRequest, ExportThemesResponse> {
            serializer = ExportThemesOperationSerializer()
            deserializer = ExportThemesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ExportThemes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplifyuibuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns an existing component for an Amplify app.
     */
    override suspend fun getComponent(input: GetComponentRequest): GetComponentResponse {
        val op = SdkHttpOperation.build<GetComponentRequest, GetComponentResponse> {
            serializer = GetComponentOperationSerializer()
            deserializer = GetComponentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetComponent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplifyuibuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns an existing theme for an Amplify app.
     */
    override suspend fun getTheme(input: GetThemeRequest): GetThemeResponse {
        val op = SdkHttpOperation.build<GetThemeRequest, GetThemeResponse> {
            serializer = GetThemeOperationSerializer()
            deserializer = GetThemeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTheme"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplifyuibuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of components for a specified Amplify app and backend environment.
     */
    override suspend fun listComponents(input: ListComponentsRequest): ListComponentsResponse {
        val op = SdkHttpOperation.build<ListComponentsRequest, ListComponentsResponse> {
            serializer = ListComponentsOperationSerializer()
            deserializer = ListComponentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListComponents"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplifyuibuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of themes for a specified Amplify app and backend environment.
     */
    override suspend fun listThemes(input: ListThemesRequest): ListThemesResponse {
        val op = SdkHttpOperation.build<ListThemesRequest, ListThemesResponse> {
            serializer = ListThemesOperationSerializer()
            deserializer = ListThemesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListThemes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplifyuibuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Refreshes a previously issued access token that might have expired.
     */
    override suspend fun refreshToken(input: RefreshTokenRequest): RefreshTokenResponse {
        val op = SdkHttpOperation.build<RefreshTokenRequest, RefreshTokenResponse> {
            serializer = RefreshTokenOperationSerializer()
            deserializer = RefreshTokenOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RefreshToken"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplifyuibuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing component.
     */
    override suspend fun updateComponent(input: UpdateComponentRequest): UpdateComponentResponse {
        val op = SdkHttpOperation.build<UpdateComponentRequest, UpdateComponentResponse> {
            serializer = UpdateComponentOperationSerializer()
            deserializer = UpdateComponentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateComponent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplifyuibuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing theme.
     */
    override suspend fun updateTheme(input: UpdateThemeRequest): UpdateThemeResponse {
        val op = SdkHttpOperation.build<UpdateThemeRequest, UpdateThemeResponse> {
            serializer = UpdateThemeOperationSerializer()
            deserializer = UpdateThemeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateTheme"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplifyuibuilder"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "amplifyuibuilder")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
