// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplifyuibuilder.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the configuration settings for a user interface (UI) element for an Amplify app. A component is configured as a primary, stand-alone UI element. Use `ComponentChild` to configure an instance of a `Component`. A `ComponentChild` instance inherits the configuration of the main `Component`.
 */
public class Component private constructor(builder: Builder) {
    /**
     * The unique ID of the Amplify app associated with the component.
     */
    public val appId: kotlin.String? = builder.appId
    /**
     * The information to connect a component's properties to data at runtime. You can't specify `tags` as a valid property for `bindingProperties`.
     */
    public val bindingProperties: Map<String, ComponentBindingPropertiesValue>? = builder.bindingProperties
    /**
     * A list of the component's `ComponentChild` instances.
     */
    public val children: List<ComponentChild>? = builder.children
    /**
     * The data binding configuration for the component's properties. Use this for a collection component. You can't specify `tags` as a valid property for `collectionProperties`.
     */
    public val collectionProperties: Map<String, ComponentDataConfiguration>? = builder.collectionProperties
    /**
     * The type of the component. This can be an Amplify custom UI component or another custom component.
     */
    public val componentType: kotlin.String? = builder.componentType
    /**
     * The time that the component was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The name of the backend environment that is a part of the Amplify app.
     */
    public val environmentName: kotlin.String? = builder.environmentName
    /**
     * Describes the events that can be raised on the component. Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.
     */
    public val events: Map<String, ComponentEvent>? = builder.events
    /**
     * The unique ID of the component.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The time that the component was modified.
     */
    public val modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.modifiedAt
    /**
     * The name of the component.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Describes the component's properties that can be overriden in a customized instance of the component. You can't specify `tags` as a valid property for `overrides`.
     */
    public val overrides: Map<String, Map<String, String>>? = builder.overrides
    /**
     * Describes the component's properties. You can't specify `tags` as a valid property for `properties`.
     */
    public val properties: Map<String, ComponentProperty>? = builder.properties
    /**
     * The schema version of the component when it was imported.
     */
    public val schemaVersion: kotlin.String? = builder.schemaVersion
    /**
     * The unique ID of the component in its original source system, such as Figma.
     */
    public val sourceId: kotlin.String? = builder.sourceId
    /**
     * One or more key-value pairs to use when tagging the component.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * A list of the component's variants. A variant is a unique style configuration of a main component.
     */
    public val variants: List<ComponentVariant>? = builder.variants

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amplifyuibuilder.model.Component = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Component(")
        append("appId=$appId,")
        append("bindingProperties=$bindingProperties,")
        append("children=$children,")
        append("collectionProperties=$collectionProperties,")
        append("componentType=$componentType,")
        append("createdAt=$createdAt,")
        append("environmentName=$environmentName,")
        append("events=$events,")
        append("id=$id,")
        append("modifiedAt=$modifiedAt,")
        append("name=$name,")
        append("overrides=$overrides,")
        append("properties=$properties,")
        append("schemaVersion=$schemaVersion,")
        append("sourceId=$sourceId,")
        append("tags=$tags,")
        append("variants=$variants)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appId?.hashCode() ?: 0
        result = 31 * result + (bindingProperties?.hashCode() ?: 0)
        result = 31 * result + (children?.hashCode() ?: 0)
        result = 31 * result + (collectionProperties?.hashCode() ?: 0)
        result = 31 * result + (componentType?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (environmentName?.hashCode() ?: 0)
        result = 31 * result + (events?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (modifiedAt?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (overrides?.hashCode() ?: 0)
        result = 31 * result + (properties?.hashCode() ?: 0)
        result = 31 * result + (schemaVersion?.hashCode() ?: 0)
        result = 31 * result + (sourceId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (variants?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Component

        if (appId != other.appId) return false
        if (bindingProperties != other.bindingProperties) return false
        if (children != other.children) return false
        if (collectionProperties != other.collectionProperties) return false
        if (componentType != other.componentType) return false
        if (createdAt != other.createdAt) return false
        if (environmentName != other.environmentName) return false
        if (events != other.events) return false
        if (id != other.id) return false
        if (modifiedAt != other.modifiedAt) return false
        if (name != other.name) return false
        if (overrides != other.overrides) return false
        if (properties != other.properties) return false
        if (schemaVersion != other.schemaVersion) return false
        if (sourceId != other.sourceId) return false
        if (tags != other.tags) return false
        if (variants != other.variants) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amplifyuibuilder.model.Component = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique ID of the Amplify app associated with the component.
         */
        public var appId: kotlin.String? = null
        /**
         * The information to connect a component's properties to data at runtime. You can't specify `tags` as a valid property for `bindingProperties`.
         */
        public var bindingProperties: Map<String, ComponentBindingPropertiesValue>? = null
        /**
         * A list of the component's `ComponentChild` instances.
         */
        public var children: List<ComponentChild>? = null
        /**
         * The data binding configuration for the component's properties. Use this for a collection component. You can't specify `tags` as a valid property for `collectionProperties`.
         */
        public var collectionProperties: Map<String, ComponentDataConfiguration>? = null
        /**
         * The type of the component. This can be an Amplify custom UI component or another custom component.
         */
        public var componentType: kotlin.String? = null
        /**
         * The time that the component was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the backend environment that is a part of the Amplify app.
         */
        public var environmentName: kotlin.String? = null
        /**
         * Describes the events that can be raised on the component. Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.
         */
        public var events: Map<String, ComponentEvent>? = null
        /**
         * The unique ID of the component.
         */
        public var id: kotlin.String? = null
        /**
         * The time that the component was modified.
         */
        public var modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the component.
         */
        public var name: kotlin.String? = null
        /**
         * Describes the component's properties that can be overriden in a customized instance of the component. You can't specify `tags` as a valid property for `overrides`.
         */
        public var overrides: Map<String, Map<String, String>>? = null
        /**
         * Describes the component's properties. You can't specify `tags` as a valid property for `properties`.
         */
        public var properties: Map<String, ComponentProperty>? = null
        /**
         * The schema version of the component when it was imported.
         */
        public var schemaVersion: kotlin.String? = null
        /**
         * The unique ID of the component in its original source system, such as Figma.
         */
        public var sourceId: kotlin.String? = null
        /**
         * One or more key-value pairs to use when tagging the component.
         */
        public var tags: Map<String, String>? = null
        /**
         * A list of the component's variants. A variant is a unique style configuration of a main component.
         */
        public var variants: List<ComponentVariant>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amplifyuibuilder.model.Component) : this() {
            this.appId = x.appId
            this.bindingProperties = x.bindingProperties
            this.children = x.children
            this.collectionProperties = x.collectionProperties
            this.componentType = x.componentType
            this.createdAt = x.createdAt
            this.environmentName = x.environmentName
            this.events = x.events
            this.id = x.id
            this.modifiedAt = x.modifiedAt
            this.name = x.name
            this.overrides = x.overrides
            this.properties = x.properties
            this.schemaVersion = x.schemaVersion
            this.sourceId = x.sourceId
            this.tags = x.tags
            this.variants = x.variants
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amplifyuibuilder.model.Component = Component(this)
    }
}
