// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplifyuibuilder.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A theme is a collection of style settings that apply globally to the components associated with an Amplify application.
 */
public class Theme private constructor(builder: Builder) {
    /**
     * The unique ID for the Amplify app associated with the theme.
     */
    public val appId: kotlin.String? = builder.appId
    /**
     * The time that the theme was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The name of the backend environment that is a part of the Amplify app.
     */
    public val environmentName: kotlin.String? = builder.environmentName
    /**
     * The ID for the theme.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The time that the theme was modified.
     */
    public val modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.modifiedAt
    /**
     * The name of the theme.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Describes the properties that can be overriden to customize a theme.
     */
    public val overrides: List<ThemeValues>? = builder.overrides
    /**
     * One or more key-value pairs to use when tagging the theme.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * A list of key-value pairs that defines the properties of the theme.
     */
    public val values: List<ThemeValues>? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amplifyuibuilder.model.Theme = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Theme(")
        append("appId=$appId,")
        append("createdAt=$createdAt,")
        append("environmentName=$environmentName,")
        append("id=$id,")
        append("modifiedAt=$modifiedAt,")
        append("name=$name,")
        append("overrides=$overrides,")
        append("tags=$tags,")
        append("values=$values)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appId?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (environmentName?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (modifiedAt?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (overrides?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Theme

        if (appId != other.appId) return false
        if (createdAt != other.createdAt) return false
        if (environmentName != other.environmentName) return false
        if (id != other.id) return false
        if (modifiedAt != other.modifiedAt) return false
        if (name != other.name) return false
        if (overrides != other.overrides) return false
        if (tags != other.tags) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amplifyuibuilder.model.Theme = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique ID for the Amplify app associated with the theme.
         */
        public var appId: kotlin.String? = null
        /**
         * The time that the theme was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the backend environment that is a part of the Amplify app.
         */
        public var environmentName: kotlin.String? = null
        /**
         * The ID for the theme.
         */
        public var id: kotlin.String? = null
        /**
         * The time that the theme was modified.
         */
        public var modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the theme.
         */
        public var name: kotlin.String? = null
        /**
         * Describes the properties that can be overriden to customize a theme.
         */
        public var overrides: List<ThemeValues>? = null
        /**
         * One or more key-value pairs to use when tagging the theme.
         */
        public var tags: Map<String, String>? = null
        /**
         * A list of key-value pairs that defines the properties of the theme.
         */
        public var values: List<ThemeValues>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amplifyuibuilder.model.Theme) : this() {
            this.appId = x.appId
            this.createdAt = x.createdAt
            this.environmentName = x.environmentName
            this.id = x.id
            this.modifiedAt = x.modifiedAt
            this.name = x.name
            this.overrides = x.overrides
            this.tags = x.tags
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amplifyuibuilder.model.Theme = Theme(this)
    }
}
