// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplifyuibuilder.transform

import aws.sdk.kotlin.services.amplifyuibuilder.model.UpdateComponentData
import aws.sdk.kotlin.services.amplifyuibuilder.model.UpdateComponentRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.parameters
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel


internal class UpdateComponentOperationSerializer: HttpSerialize<UpdateComponentRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateComponentRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            val pathSegments = listOf(
                "app",
                "${input.appId}".encodeLabel(),
                "environment",
                "${input.environmentName}".encodeLabel(),
                "components",
                "${input.id}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                append("clientToken", (input.clientToken ?: context.idempotencyTokenProvider.generateToken()))
            }
        }

        if (input.updatedComponent != null) {
            val payload = serializeUpdateComponentDataPayload(input.updatedComponent)
            builder.body = ByteArrayContent(payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        if (input.updatedComponent == null) {
            builder.body = ByteArrayContent("{}".encodeToByteArray())
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}
