// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplifyuibuilder

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.amplifyuibuilder.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.amplifyuibuilder.endpoints.EndpointProvider
import aws.sdk.kotlin.services.amplifyuibuilder.model.*
import aws.sdk.kotlin.services.amplifyuibuilder.model.CreateComponentRequest
import aws.sdk.kotlin.services.amplifyuibuilder.model.CreateComponentResponse
import aws.sdk.kotlin.services.amplifyuibuilder.model.CreateFormRequest
import aws.sdk.kotlin.services.amplifyuibuilder.model.CreateFormResponse
import aws.sdk.kotlin.services.amplifyuibuilder.model.CreateThemeRequest
import aws.sdk.kotlin.services.amplifyuibuilder.model.CreateThemeResponse
import aws.sdk.kotlin.services.amplifyuibuilder.model.DeleteComponentRequest
import aws.sdk.kotlin.services.amplifyuibuilder.model.DeleteComponentResponse
import aws.sdk.kotlin.services.amplifyuibuilder.model.DeleteFormRequest
import aws.sdk.kotlin.services.amplifyuibuilder.model.DeleteFormResponse
import aws.sdk.kotlin.services.amplifyuibuilder.model.DeleteThemeRequest
import aws.sdk.kotlin.services.amplifyuibuilder.model.DeleteThemeResponse
import aws.sdk.kotlin.services.amplifyuibuilder.model.ExchangeCodeForTokenRequest
import aws.sdk.kotlin.services.amplifyuibuilder.model.ExchangeCodeForTokenResponse
import aws.sdk.kotlin.services.amplifyuibuilder.model.ExportComponentsRequest
import aws.sdk.kotlin.services.amplifyuibuilder.model.ExportComponentsResponse
import aws.sdk.kotlin.services.amplifyuibuilder.model.ExportFormsRequest
import aws.sdk.kotlin.services.amplifyuibuilder.model.ExportFormsResponse
import aws.sdk.kotlin.services.amplifyuibuilder.model.ExportThemesRequest
import aws.sdk.kotlin.services.amplifyuibuilder.model.ExportThemesResponse
import aws.sdk.kotlin.services.amplifyuibuilder.model.GetComponentRequest
import aws.sdk.kotlin.services.amplifyuibuilder.model.GetComponentResponse
import aws.sdk.kotlin.services.amplifyuibuilder.model.GetFormRequest
import aws.sdk.kotlin.services.amplifyuibuilder.model.GetFormResponse
import aws.sdk.kotlin.services.amplifyuibuilder.model.GetMetadataRequest
import aws.sdk.kotlin.services.amplifyuibuilder.model.GetMetadataResponse
import aws.sdk.kotlin.services.amplifyuibuilder.model.GetThemeRequest
import aws.sdk.kotlin.services.amplifyuibuilder.model.GetThemeResponse
import aws.sdk.kotlin.services.amplifyuibuilder.model.ListComponentsRequest
import aws.sdk.kotlin.services.amplifyuibuilder.model.ListComponentsResponse
import aws.sdk.kotlin.services.amplifyuibuilder.model.ListFormsRequest
import aws.sdk.kotlin.services.amplifyuibuilder.model.ListFormsResponse
import aws.sdk.kotlin.services.amplifyuibuilder.model.ListThemesRequest
import aws.sdk.kotlin.services.amplifyuibuilder.model.ListThemesResponse
import aws.sdk.kotlin.services.amplifyuibuilder.model.PutMetadataFlagRequest
import aws.sdk.kotlin.services.amplifyuibuilder.model.PutMetadataFlagResponse
import aws.sdk.kotlin.services.amplifyuibuilder.model.RefreshTokenRequest
import aws.sdk.kotlin.services.amplifyuibuilder.model.RefreshTokenResponse
import aws.sdk.kotlin.services.amplifyuibuilder.model.UpdateComponentRequest
import aws.sdk.kotlin.services.amplifyuibuilder.model.UpdateComponentResponse
import aws.sdk.kotlin.services.amplifyuibuilder.model.UpdateFormRequest
import aws.sdk.kotlin.services.amplifyuibuilder.model.UpdateFormResponse
import aws.sdk.kotlin.services.amplifyuibuilder.model.UpdateThemeRequest
import aws.sdk.kotlin.services.amplifyuibuilder.model.UpdateThemeResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig

/**
 * The Amplify UI Builder API provides a programmatic interface for creating and configuring user interface (UI) component libraries and themes for use in your Amplify applications. You can then connect these UI components to an application's backend Amazon Web Services resources.
 *
 * You can also use the Amplify Studio visual designer to create UI components and model data for an app. For more information, see [Introduction](https://docs.amplify.aws/console/adminui/intro) in the *Amplify Docs*.
 *
 * The Amplify Framework is a comprehensive set of SDKs, libraries, tools, and documentation for client app development. For more information, see the [Amplify Framework](https://docs.amplify.aws/). For more information about deploying an Amplify application to Amazon Web Services, see the [Amplify User Guide](https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html).
 */
public interface AmplifyUiBuilderClient : SdkClient {

    override val serviceName: String
        get() = "AmplifyUIBuilder"
    /**
     * AmplifyUiBuilderClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): AmplifyUiBuilderClient {
            val config = Config.Builder().apply(block).build()
            return DefaultAmplifyUiBuilderClient(config)
        }

        public operator fun invoke(config: Config): AmplifyUiBuilderClient = DefaultAmplifyUiBuilderClient(config)

        /**
         * Construct a [AmplifyUiBuilderClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): AmplifyUiBuilderClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultAmplifyUiBuilderClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "AmplifyUIBuilder")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null
            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null
            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            public var tracer: Tracer? = null
            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false
            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a new component for an Amplify app.
     */
    public suspend fun createComponent(input: CreateComponentRequest): CreateComponentResponse

    /**
     * Creates a new form for an Amplify app.
     */
    public suspend fun createForm(input: CreateFormRequest): CreateFormResponse

    /**
     * Creates a theme to apply to the components in an Amplify app.
     */
    public suspend fun createTheme(input: CreateThemeRequest): CreateThemeResponse

    /**
     * Deletes a component from an Amplify app.
     */
    public suspend fun deleteComponent(input: DeleteComponentRequest): DeleteComponentResponse

    /**
     * Deletes a form from an Amplify app.
     */
    public suspend fun deleteForm(input: DeleteFormRequest): DeleteFormResponse

    /**
     * Deletes a theme from an Amplify app.
     */
    public suspend fun deleteTheme(input: DeleteThemeRequest): DeleteThemeResponse

    /**
     * Exchanges an access code for a token.
     */
    public suspend fun exchangeCodeForToken(input: ExchangeCodeForTokenRequest): ExchangeCodeForTokenResponse

    /**
     * Exports component configurations to code that is ready to integrate into an Amplify app.
     */
    public suspend fun exportComponents(input: ExportComponentsRequest): ExportComponentsResponse

    /**
     * Exports form configurations to code that is ready to integrate into an Amplify app.
     */
    public suspend fun exportForms(input: ExportFormsRequest): ExportFormsResponse

    /**
     * Exports theme configurations to code that is ready to integrate into an Amplify app.
     */
    public suspend fun exportThemes(input: ExportThemesRequest): ExportThemesResponse

    /**
     * Returns an existing component for an Amplify app.
     */
    public suspend fun getComponent(input: GetComponentRequest): GetComponentResponse

    /**
     * Returns an existing form for an Amplify app.
     */
    public suspend fun getForm(input: GetFormRequest): GetFormResponse

    /**
     * Returns existing metadata for an Amplify app.
     */
    public suspend fun getMetadata(input: GetMetadataRequest): GetMetadataResponse

    /**
     * Returns an existing theme for an Amplify app.
     */
    public suspend fun getTheme(input: GetThemeRequest): GetThemeResponse

    /**
     * Retrieves a list of components for a specified Amplify app and backend environment.
     */
    public suspend fun listComponents(input: ListComponentsRequest): ListComponentsResponse

    /**
     * Retrieves a list of forms for a specified Amplify app and backend environment.
     */
    public suspend fun listForms(input: ListFormsRequest): ListFormsResponse

    /**
     * Retrieves a list of themes for a specified Amplify app and backend environment.
     */
    public suspend fun listThemes(input: ListThemesRequest): ListThemesResponse

    /**
     * Stores the metadata information about a feature on a form or view.
     */
    public suspend fun putMetadataFlag(input: PutMetadataFlagRequest): PutMetadataFlagResponse

    /**
     * Refreshes a previously issued access token that might have expired.
     */
    public suspend fun refreshToken(input: RefreshTokenRequest): RefreshTokenResponse

    /**
     * Updates an existing component.
     */
    public suspend fun updateComponent(input: UpdateComponentRequest): UpdateComponentResponse

    /**
     * Updates an existing form.
     */
    public suspend fun updateForm(input: UpdateFormRequest): UpdateFormResponse

    /**
     * Updates an existing theme.
     */
    public suspend fun updateTheme(input: UpdateThemeRequest): UpdateThemeResponse
}

/**
 * Creates a new component for an Amplify app.
 */
public suspend inline fun AmplifyUiBuilderClient.createComponent(crossinline block: CreateComponentRequest.Builder.() -> Unit): CreateComponentResponse = createComponent(CreateComponentRequest.Builder().apply(block).build())

/**
 * Creates a new form for an Amplify app.
 */
public suspend inline fun AmplifyUiBuilderClient.createForm(crossinline block: CreateFormRequest.Builder.() -> Unit): CreateFormResponse = createForm(CreateFormRequest.Builder().apply(block).build())

/**
 * Creates a theme to apply to the components in an Amplify app.
 */
public suspend inline fun AmplifyUiBuilderClient.createTheme(crossinline block: CreateThemeRequest.Builder.() -> Unit): CreateThemeResponse = createTheme(CreateThemeRequest.Builder().apply(block).build())

/**
 * Deletes a component from an Amplify app.
 */
public suspend inline fun AmplifyUiBuilderClient.deleteComponent(crossinline block: DeleteComponentRequest.Builder.() -> Unit): DeleteComponentResponse = deleteComponent(DeleteComponentRequest.Builder().apply(block).build())

/**
 * Deletes a form from an Amplify app.
 */
public suspend inline fun AmplifyUiBuilderClient.deleteForm(crossinline block: DeleteFormRequest.Builder.() -> Unit): DeleteFormResponse = deleteForm(DeleteFormRequest.Builder().apply(block).build())

/**
 * Deletes a theme from an Amplify app.
 */
public suspend inline fun AmplifyUiBuilderClient.deleteTheme(crossinline block: DeleteThemeRequest.Builder.() -> Unit): DeleteThemeResponse = deleteTheme(DeleteThemeRequest.Builder().apply(block).build())

/**
 * Exchanges an access code for a token.
 */
public suspend inline fun AmplifyUiBuilderClient.exchangeCodeForToken(crossinline block: ExchangeCodeForTokenRequest.Builder.() -> Unit): ExchangeCodeForTokenResponse = exchangeCodeForToken(ExchangeCodeForTokenRequest.Builder().apply(block).build())

/**
 * Exports component configurations to code that is ready to integrate into an Amplify app.
 */
public suspend inline fun AmplifyUiBuilderClient.exportComponents(crossinline block: ExportComponentsRequest.Builder.() -> Unit): ExportComponentsResponse = exportComponents(ExportComponentsRequest.Builder().apply(block).build())

/**
 * Exports form configurations to code that is ready to integrate into an Amplify app.
 */
public suspend inline fun AmplifyUiBuilderClient.exportForms(crossinline block: ExportFormsRequest.Builder.() -> Unit): ExportFormsResponse = exportForms(ExportFormsRequest.Builder().apply(block).build())

/**
 * Exports theme configurations to code that is ready to integrate into an Amplify app.
 */
public suspend inline fun AmplifyUiBuilderClient.exportThemes(crossinline block: ExportThemesRequest.Builder.() -> Unit): ExportThemesResponse = exportThemes(ExportThemesRequest.Builder().apply(block).build())

/**
 * Returns an existing component for an Amplify app.
 */
public suspend inline fun AmplifyUiBuilderClient.getComponent(crossinline block: GetComponentRequest.Builder.() -> Unit): GetComponentResponse = getComponent(GetComponentRequest.Builder().apply(block).build())

/**
 * Returns an existing form for an Amplify app.
 */
public suspend inline fun AmplifyUiBuilderClient.getForm(crossinline block: GetFormRequest.Builder.() -> Unit): GetFormResponse = getForm(GetFormRequest.Builder().apply(block).build())

/**
 * Returns existing metadata for an Amplify app.
 */
public suspend inline fun AmplifyUiBuilderClient.getMetadata(crossinline block: GetMetadataRequest.Builder.() -> Unit): GetMetadataResponse = getMetadata(GetMetadataRequest.Builder().apply(block).build())

/**
 * Returns an existing theme for an Amplify app.
 */
public suspend inline fun AmplifyUiBuilderClient.getTheme(crossinline block: GetThemeRequest.Builder.() -> Unit): GetThemeResponse = getTheme(GetThemeRequest.Builder().apply(block).build())

/**
 * Retrieves a list of components for a specified Amplify app and backend environment.
 */
public suspend inline fun AmplifyUiBuilderClient.listComponents(crossinline block: ListComponentsRequest.Builder.() -> Unit): ListComponentsResponse = listComponents(ListComponentsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of forms for a specified Amplify app and backend environment.
 */
public suspend inline fun AmplifyUiBuilderClient.listForms(crossinline block: ListFormsRequest.Builder.() -> Unit): ListFormsResponse = listForms(ListFormsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of themes for a specified Amplify app and backend environment.
 */
public suspend inline fun AmplifyUiBuilderClient.listThemes(crossinline block: ListThemesRequest.Builder.() -> Unit): ListThemesResponse = listThemes(ListThemesRequest.Builder().apply(block).build())

/**
 * Stores the metadata information about a feature on a form or view.
 */
public suspend inline fun AmplifyUiBuilderClient.putMetadataFlag(crossinline block: PutMetadataFlagRequest.Builder.() -> Unit): PutMetadataFlagResponse = putMetadataFlag(PutMetadataFlagRequest.Builder().apply(block).build())

/**
 * Refreshes a previously issued access token that might have expired.
 */
public suspend inline fun AmplifyUiBuilderClient.refreshToken(crossinline block: RefreshTokenRequest.Builder.() -> Unit): RefreshTokenResponse = refreshToken(RefreshTokenRequest.Builder().apply(block).build())

/**
 * Updates an existing component.
 */
public suspend inline fun AmplifyUiBuilderClient.updateComponent(crossinline block: UpdateComponentRequest.Builder.() -> Unit): UpdateComponentResponse = updateComponent(UpdateComponentRequest.Builder().apply(block).build())

/**
 * Updates an existing form.
 */
public suspend inline fun AmplifyUiBuilderClient.updateForm(crossinline block: UpdateFormRequest.Builder.() -> Unit): UpdateFormResponse = updateForm(UpdateFormRequest.Builder().apply(block).build())

/**
 * Updates an existing theme.
 */
public suspend inline fun AmplifyUiBuilderClient.updateTheme(crossinline block: UpdateThemeRequest.Builder.() -> Unit): UpdateThemeResponse = updateTheme(UpdateThemeRequest.Builder().apply(block).build())
