// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplifyuibuilder.model



/**
 * Describes the configuration for all of a component's properties. Use `ComponentProperty` to specify the values to render or bind by default.
 */
public class ComponentProperty private constructor(builder: Builder) {
    /**
     * The information to bind the component property to data at runtime.
     */
    public val bindingProperties: aws.sdk.kotlin.services.amplifyuibuilder.model.ComponentPropertyBindingProperties? = builder.bindingProperties
    /**
     * The information to bind the component property to form data.
     */
    public val bindings: Map<String, FormBindingElement>? = builder.bindings
    /**
     * The information to bind the component property to data at runtime. Use this for collection components.
     */
    public val collectionBindingProperties: aws.sdk.kotlin.services.amplifyuibuilder.model.ComponentPropertyBindingProperties? = builder.collectionBindingProperties
    /**
     * The name of the component that is affected by an event.
     */
    public val componentName: kotlin.String? = builder.componentName
    /**
     * A list of component properties to concatenate to create the value to assign to this component property.
     */
    public val concat: List<ComponentProperty>? = builder.concat
    /**
     * The conditional expression to use to assign a value to the component property.
     */
    public val condition: aws.sdk.kotlin.services.amplifyuibuilder.model.ComponentConditionProperty? = builder.condition
    /**
     * Specifies whether the user configured the property in Amplify Studio after importing it.
     */
    public val configured: kotlin.Boolean? = builder.configured
    /**
     * The default value to assign to the component property.
     */
    public val defaultValue: kotlin.String? = builder.defaultValue
    /**
     * An event that occurs in your app. Use this for workflow data binding.
     */
    public val event: kotlin.String? = builder.event
    /**
     * The default value assigned to the property when the component is imported into an app.
     */
    public val importedValue: kotlin.String? = builder.importedValue
    /**
     * The data model to use to assign a value to the component property.
     */
    public val model: kotlin.String? = builder.model
    /**
     * The name of the component's property that is affected by an event.
     */
    public val property: kotlin.String? = builder.property
    /**
     * The component type.
     */
    public val type: kotlin.String? = builder.type
    /**
     * An authenticated user attribute to use to assign a value to the component property.
     */
    public val userAttribute: kotlin.String? = builder.userAttribute
    /**
     * The value to assign to the component property.
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amplifyuibuilder.model.ComponentProperty = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ComponentProperty(")
        append("bindingProperties=$bindingProperties,")
        append("bindings=$bindings,")
        append("collectionBindingProperties=$collectionBindingProperties,")
        append("componentName=$componentName,")
        append("concat=$concat,")
        append("condition=$condition,")
        append("configured=$configured,")
        append("defaultValue=$defaultValue,")
        append("event=$event,")
        append("importedValue=$importedValue,")
        append("model=$model,")
        append("property=$property,")
        append("type=$type,")
        append("userAttribute=$userAttribute,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bindingProperties?.hashCode() ?: 0
        result = 31 * result + (bindings?.hashCode() ?: 0)
        result = 31 * result + (collectionBindingProperties?.hashCode() ?: 0)
        result = 31 * result + (componentName?.hashCode() ?: 0)
        result = 31 * result + (concat?.hashCode() ?: 0)
        result = 31 * result + (condition?.hashCode() ?: 0)
        result = 31 * result + (configured?.hashCode() ?: 0)
        result = 31 * result + (defaultValue?.hashCode() ?: 0)
        result = 31 * result + (event?.hashCode() ?: 0)
        result = 31 * result + (importedValue?.hashCode() ?: 0)
        result = 31 * result + (model?.hashCode() ?: 0)
        result = 31 * result + (property?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (userAttribute?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ComponentProperty

        if (bindingProperties != other.bindingProperties) return false
        if (bindings != other.bindings) return false
        if (collectionBindingProperties != other.collectionBindingProperties) return false
        if (componentName != other.componentName) return false
        if (concat != other.concat) return false
        if (condition != other.condition) return false
        if (configured != other.configured) return false
        if (defaultValue != other.defaultValue) return false
        if (event != other.event) return false
        if (importedValue != other.importedValue) return false
        if (model != other.model) return false
        if (property != other.property) return false
        if (type != other.type) return false
        if (userAttribute != other.userAttribute) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amplifyuibuilder.model.ComponentProperty = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The information to bind the component property to data at runtime.
         */
        public var bindingProperties: aws.sdk.kotlin.services.amplifyuibuilder.model.ComponentPropertyBindingProperties? = null
        /**
         * The information to bind the component property to form data.
         */
        public var bindings: Map<String, FormBindingElement>? = null
        /**
         * The information to bind the component property to data at runtime. Use this for collection components.
         */
        public var collectionBindingProperties: aws.sdk.kotlin.services.amplifyuibuilder.model.ComponentPropertyBindingProperties? = null
        /**
         * The name of the component that is affected by an event.
         */
        public var componentName: kotlin.String? = null
        /**
         * A list of component properties to concatenate to create the value to assign to this component property.
         */
        public var concat: List<ComponentProperty>? = null
        /**
         * The conditional expression to use to assign a value to the component property.
         */
        public var condition: aws.sdk.kotlin.services.amplifyuibuilder.model.ComponentConditionProperty? = null
        /**
         * Specifies whether the user configured the property in Amplify Studio after importing it.
         */
        public var configured: kotlin.Boolean? = null
        /**
         * The default value to assign to the component property.
         */
        public var defaultValue: kotlin.String? = null
        /**
         * An event that occurs in your app. Use this for workflow data binding.
         */
        public var event: kotlin.String? = null
        /**
         * The default value assigned to the property when the component is imported into an app.
         */
        public var importedValue: kotlin.String? = null
        /**
         * The data model to use to assign a value to the component property.
         */
        public var model: kotlin.String? = null
        /**
         * The name of the component's property that is affected by an event.
         */
        public var property: kotlin.String? = null
        /**
         * The component type.
         */
        public var type: kotlin.String? = null
        /**
         * An authenticated user attribute to use to assign a value to the component property.
         */
        public var userAttribute: kotlin.String? = null
        /**
         * The value to assign to the component property.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amplifyuibuilder.model.ComponentProperty) : this() {
            this.bindingProperties = x.bindingProperties
            this.bindings = x.bindings
            this.collectionBindingProperties = x.collectionBindingProperties
            this.componentName = x.componentName
            this.concat = x.concat
            this.condition = x.condition
            this.configured = x.configured
            this.defaultValue = x.defaultValue
            this.event = x.event
            this.importedValue = x.importedValue
            this.model = x.model
            this.property = x.property
            this.type = x.type
            this.userAttribute = x.userAttribute
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amplifyuibuilder.model.ComponentProperty = ComponentProperty(this)

        /**
         * construct an [aws.sdk.kotlin.services.amplifyuibuilder.model.ComponentPropertyBindingProperties] inside the given [block]
         */
        public fun bindingProperties(block: aws.sdk.kotlin.services.amplifyuibuilder.model.ComponentPropertyBindingProperties.Builder.() -> kotlin.Unit) {
            this.bindingProperties = aws.sdk.kotlin.services.amplifyuibuilder.model.ComponentPropertyBindingProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.amplifyuibuilder.model.ComponentPropertyBindingProperties] inside the given [block]
         */
        public fun collectionBindingProperties(block: aws.sdk.kotlin.services.amplifyuibuilder.model.ComponentPropertyBindingProperties.Builder.() -> kotlin.Unit) {
            this.collectionBindingProperties = aws.sdk.kotlin.services.amplifyuibuilder.model.ComponentPropertyBindingProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.amplifyuibuilder.model.ComponentConditionProperty] inside the given [block]
         */
        public fun condition(block: aws.sdk.kotlin.services.amplifyuibuilder.model.ComponentConditionProperty.Builder.() -> kotlin.Unit) {
            this.condition = aws.sdk.kotlin.services.amplifyuibuilder.model.ComponentConditionProperty.invoke(block)
        }
    }
}
