// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplifyuibuilder.model



/**
 * Contains the configuration settings for a `Form` user interface (UI) element for an Amplify app. A form is a component you can add to your project by specifying a data source as the default configuration for the form.
 */
public class Form private constructor(builder: Builder) {
    /**
     * The unique ID of the Amplify app associated with the form.
     */
    public val appId: kotlin.String? = builder.appId
    /**
     * Stores the call to action configuration for the form.
     */
    public val cta: aws.sdk.kotlin.services.amplifyuibuilder.model.FormCta? = builder.cta
    /**
     * The type of data source to use to create the form.
     */
    public val dataType: aws.sdk.kotlin.services.amplifyuibuilder.model.FormDataTypeConfig? = builder.dataType
    /**
     * The name of the backend environment that is a part of the Amplify app.
     */
    public val environmentName: kotlin.String? = builder.environmentName
    /**
     * Stores the information about the form's fields.
     */
    public val fields: Map<String, FieldConfig>? = builder.fields
    /**
     * The operation to perform on the specified form.
     */
    public val formActionType: aws.sdk.kotlin.services.amplifyuibuilder.model.FormActionType? = builder.formActionType
    /**
     * The unique ID of the form.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The name of the form.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The schema version of the form when it was imported.
     */
    public val schemaVersion: kotlin.String? = builder.schemaVersion
    /**
     * Stores the visual helper elements for the form that are not associated with any data.
     */
    public val sectionalElements: Map<String, SectionalElement>? = builder.sectionalElements
    /**
     * Stores the configuration for the form's style.
     */
    public val style: aws.sdk.kotlin.services.amplifyuibuilder.model.FormStyle? = builder.style
    /**
     * One or more key-value pairs to use when tagging the form.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amplifyuibuilder.model.Form = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Form(")
        append("appId=$appId,")
        append("cta=$cta,")
        append("dataType=$dataType,")
        append("environmentName=$environmentName,")
        append("fields=$fields,")
        append("formActionType=$formActionType,")
        append("id=$id,")
        append("name=$name,")
        append("schemaVersion=$schemaVersion,")
        append("sectionalElements=$sectionalElements,")
        append("style=$style,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appId?.hashCode() ?: 0
        result = 31 * result + (cta?.hashCode() ?: 0)
        result = 31 * result + (dataType?.hashCode() ?: 0)
        result = 31 * result + (environmentName?.hashCode() ?: 0)
        result = 31 * result + (fields?.hashCode() ?: 0)
        result = 31 * result + (formActionType?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (schemaVersion?.hashCode() ?: 0)
        result = 31 * result + (sectionalElements?.hashCode() ?: 0)
        result = 31 * result + (style?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Form

        if (appId != other.appId) return false
        if (cta != other.cta) return false
        if (dataType != other.dataType) return false
        if (environmentName != other.environmentName) return false
        if (fields != other.fields) return false
        if (formActionType != other.formActionType) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (schemaVersion != other.schemaVersion) return false
        if (sectionalElements != other.sectionalElements) return false
        if (style != other.style) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amplifyuibuilder.model.Form = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique ID of the Amplify app associated with the form.
         */
        public var appId: kotlin.String? = null
        /**
         * Stores the call to action configuration for the form.
         */
        public var cta: aws.sdk.kotlin.services.amplifyuibuilder.model.FormCta? = null
        /**
         * The type of data source to use to create the form.
         */
        public var dataType: aws.sdk.kotlin.services.amplifyuibuilder.model.FormDataTypeConfig? = null
        /**
         * The name of the backend environment that is a part of the Amplify app.
         */
        public var environmentName: kotlin.String? = null
        /**
         * Stores the information about the form's fields.
         */
        public var fields: Map<String, FieldConfig>? = null
        /**
         * The operation to perform on the specified form.
         */
        public var formActionType: aws.sdk.kotlin.services.amplifyuibuilder.model.FormActionType? = null
        /**
         * The unique ID of the form.
         */
        public var id: kotlin.String? = null
        /**
         * The name of the form.
         */
        public var name: kotlin.String? = null
        /**
         * The schema version of the form when it was imported.
         */
        public var schemaVersion: kotlin.String? = null
        /**
         * Stores the visual helper elements for the form that are not associated with any data.
         */
        public var sectionalElements: Map<String, SectionalElement>? = null
        /**
         * Stores the configuration for the form's style.
         */
        public var style: aws.sdk.kotlin.services.amplifyuibuilder.model.FormStyle? = null
        /**
         * One or more key-value pairs to use when tagging the form.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amplifyuibuilder.model.Form) : this() {
            this.appId = x.appId
            this.cta = x.cta
            this.dataType = x.dataType
            this.environmentName = x.environmentName
            this.fields = x.fields
            this.formActionType = x.formActionType
            this.id = x.id
            this.name = x.name
            this.schemaVersion = x.schemaVersion
            this.sectionalElements = x.sectionalElements
            this.style = x.style
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amplifyuibuilder.model.Form = Form(this)

        /**
         * construct an [aws.sdk.kotlin.services.amplifyuibuilder.model.FormCta] inside the given [block]
         */
        public fun cta(block: aws.sdk.kotlin.services.amplifyuibuilder.model.FormCta.Builder.() -> kotlin.Unit) {
            this.cta = aws.sdk.kotlin.services.amplifyuibuilder.model.FormCta.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.amplifyuibuilder.model.FormDataTypeConfig] inside the given [block]
         */
        public fun dataType(block: aws.sdk.kotlin.services.amplifyuibuilder.model.FormDataTypeConfig.Builder.() -> kotlin.Unit) {
            this.dataType = aws.sdk.kotlin.services.amplifyuibuilder.model.FormDataTypeConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.amplifyuibuilder.model.FormStyle] inside the given [block]
         */
        public fun style(block: aws.sdk.kotlin.services.amplifyuibuilder.model.FormStyle.Builder.() -> kotlin.Unit) {
            this.style = aws.sdk.kotlin.services.amplifyuibuilder.model.FormStyle.invoke(block)
        }
    }
}
