// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplifyuibuilder.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.amplifyuibuilder.model.AmplifyUiBuilderException
import aws.sdk.kotlin.services.amplifyuibuilder.model.ExchangeCodeForTokenResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ExchangeCodeForTokenOperationDeserializer: HttpDeserialize<ExchangeCodeForTokenResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ExchangeCodeForTokenResponse {
        if (!response.status.isSuccess()) {
            throwExchangeCodeForTokenError(context, response)
        }
        val builder = ExchangeCodeForTokenResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeExchangeCodeForTokenOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwExchangeCodeForTokenError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw AmplifyUiBuilderException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> AmplifyUiBuilderException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeExchangeCodeForTokenOperationBody(builder: ExchangeCodeForTokenResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCESSTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("accessToken"))
    val EXPIRESIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("expiresIn"))
    val REFRESHTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("refreshToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCESSTOKEN_DESCRIPTOR)
        field(EXPIRESIN_DESCRIPTOR)
        field(REFRESHTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCESSTOKEN_DESCRIPTOR.index -> builder.accessToken = deserializeString()
                EXPIRESIN_DESCRIPTOR.index -> builder.expiresIn = deserializeInt()
                REFRESHTOKEN_DESCRIPTOR.index -> builder.refreshToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
