// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplifyuibuilder.transform

import aws.sdk.kotlin.services.amplifyuibuilder.model.UpdateFormData
import aws.sdk.kotlin.services.amplifyuibuilder.model.UpdateFormRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.parameters
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel


internal class UpdateFormOperationSerializer: HttpSerialize<UpdateFormRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateFormRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            val pathSegments = listOf<String>(
                "app",
                "${input.appId}".encodeLabel(),
                "environment",
                "${input.environmentName}".encodeLabel(),
                "forms",
                "${input.id}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                append("clientToken", (input.clientToken ?: context.idempotencyTokenProvider.generateToken()))
            }
        }

        if (input.updatedForm != null) {
            val payload = serializeUpdateFormDataPayload(input.updatedForm)
            builder.body = ByteArrayContent(payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        if (input.updatedForm == null) {
            builder.body = ByteArrayContent("{}".encodeToByteArray())
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}
