// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplifyuibuilder

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.amplifyuibuilder.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.amplifyuibuilder.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * The Amplify UI Builder API provides a programmatic interface for creating
 * and configuring user interface (UI) component libraries and themes for use in your Amplify applications. You can then connect these UI components to an application's
 * backend Amazon Web Services resources.
 * You can also use the Amplify Studio visual designer to create UI components
 * and model data for an app. For more information, see <a href="https://docs.amplify.aws/console/adminui/intro">Introduction in the
 * Amplify Docs.
 * The Amplify Framework is a comprehensive set of SDKs, libraries, tools, and
 * documentation for client app development. For more information, see the <a href="https://docs.amplify.aws/">Amplify Framework. For more information about
 * deploying an Amplify application to Amazon Web Services, see the <a href="https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html">Amplify User Guide.
 */
interface AmplifyUiBuilderClient : SdkClient {

    override val serviceName: String
        get() = "AmplifyUIBuilder"
    /**
     * AmplifyUiBuilderClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): AmplifyUiBuilderClient {
            val config = Config.Builder().apply(block).build()
            return DefaultAmplifyUiBuilderClient(config)
        }

        operator fun invoke(config: Config): AmplifyUiBuilderClient = DefaultAmplifyUiBuilderClient(config)

        /**
         * Construct a [AmplifyUiBuilderClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): AmplifyUiBuilderClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultAmplifyUiBuilderClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a new component for an Amplify app.
     */
    suspend fun createComponent(input: CreateComponentRequest): CreateComponentResponse

    /**
     * Creates a new component for an Amplify app.
     */
    suspend fun createComponent(block: CreateComponentRequest.Builder.() -> Unit) = createComponent(CreateComponentRequest.Builder().apply(block).build())

    /**
     * Creates a theme to apply to the components in an Amplify app.
     */
    suspend fun createTheme(input: CreateThemeRequest): CreateThemeResponse

    /**
     * Creates a theme to apply to the components in an Amplify app.
     */
    suspend fun createTheme(block: CreateThemeRequest.Builder.() -> Unit) = createTheme(CreateThemeRequest.Builder().apply(block).build())

    /**
     * Deletes a component from an Amplify app.
     */
    suspend fun deleteComponent(input: DeleteComponentRequest): DeleteComponentResponse

    /**
     * Deletes a component from an Amplify app.
     */
    suspend fun deleteComponent(block: DeleteComponentRequest.Builder.() -> Unit) = deleteComponent(DeleteComponentRequest.Builder().apply(block).build())

    /**
     * Deletes a theme from an Amplify app.
     */
    suspend fun deleteTheme(input: DeleteThemeRequest): DeleteThemeResponse

    /**
     * Deletes a theme from an Amplify app.
     */
    suspend fun deleteTheme(block: DeleteThemeRequest.Builder.() -> Unit) = deleteTheme(DeleteThemeRequest.Builder().apply(block).build())

    /**
     * Exchanges an access code for a token.
     */
    suspend fun exchangeCodeForToken(input: ExchangeCodeForTokenRequest): ExchangeCodeForTokenResponse

    /**
     * Exchanges an access code for a token.
     */
    suspend fun exchangeCodeForToken(block: ExchangeCodeForTokenRequest.Builder.() -> Unit) = exchangeCodeForToken(ExchangeCodeForTokenRequest.Builder().apply(block).build())

    /**
     * Exports component configurations to code that is ready to integrate into an Amplify app.
     */
    suspend fun exportComponents(input: ExportComponentsRequest): ExportComponentsResponse

    /**
     * Exports component configurations to code that is ready to integrate into an Amplify app.
     */
    suspend fun exportComponents(block: ExportComponentsRequest.Builder.() -> Unit) = exportComponents(ExportComponentsRequest.Builder().apply(block).build())

    /**
     * Exports theme configurations to code that is ready to integrate into an Amplify app.
     */
    suspend fun exportThemes(input: ExportThemesRequest): ExportThemesResponse

    /**
     * Exports theme configurations to code that is ready to integrate into an Amplify app.
     */
    suspend fun exportThemes(block: ExportThemesRequest.Builder.() -> Unit) = exportThemes(ExportThemesRequest.Builder().apply(block).build())

    /**
     * Returns an existing component for an Amplify app.
     */
    suspend fun getComponent(input: GetComponentRequest): GetComponentResponse

    /**
     * Returns an existing component for an Amplify app.
     */
    suspend fun getComponent(block: GetComponentRequest.Builder.() -> Unit) = getComponent(GetComponentRequest.Builder().apply(block).build())

    /**
     * Returns an existing theme for an Amplify app.
     */
    suspend fun getTheme(input: GetThemeRequest): GetThemeResponse

    /**
     * Returns an existing theme for an Amplify app.
     */
    suspend fun getTheme(block: GetThemeRequest.Builder.() -> Unit) = getTheme(GetThemeRequest.Builder().apply(block).build())

    /**
     * Retrieves a list of components for a specified Amplify app and backend
     * environment.
     */
    suspend fun listComponents(input: ListComponentsRequest): ListComponentsResponse

    /**
     * Retrieves a list of components for a specified Amplify app and backend
     * environment.
     */
    suspend fun listComponents(block: ListComponentsRequest.Builder.() -> Unit) = listComponents(ListComponentsRequest.Builder().apply(block).build())

    /**
     * Retrieves a list of themes for a specified Amplify app and backend
     * environment.
     */
    suspend fun listThemes(input: ListThemesRequest): ListThemesResponse

    /**
     * Retrieves a list of themes for a specified Amplify app and backend
     * environment.
     */
    suspend fun listThemes(block: ListThemesRequest.Builder.() -> Unit) = listThemes(ListThemesRequest.Builder().apply(block).build())

    /**
     * Refreshes a previously issued access token that might have expired.
     */
    suspend fun refreshToken(input: RefreshTokenRequest): RefreshTokenResponse

    /**
     * Refreshes a previously issued access token that might have expired.
     */
    suspend fun refreshToken(block: RefreshTokenRequest.Builder.() -> Unit) = refreshToken(RefreshTokenRequest.Builder().apply(block).build())

    /**
     * Updates an existing component.
     */
    suspend fun updateComponent(input: UpdateComponentRequest): UpdateComponentResponse

    /**
     * Updates an existing component.
     */
    suspend fun updateComponent(block: UpdateComponentRequest.Builder.() -> Unit) = updateComponent(UpdateComponentRequest.Builder().apply(block).build())

    /**
     * Updates an existing theme.
     */
    suspend fun updateTheme(input: UpdateThemeRequest): UpdateThemeResponse

    /**
     * Updates an existing theme.
     */
    suspend fun updateTheme(block: UpdateThemeRequest.Builder.() -> Unit) = updateTheme(UpdateThemeRequest.Builder().apply(block).build())
}
