// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplifyuibuilder.model



/**
 * Represents all of the information that is required to create a component.
 */
class CreateComponentData private constructor(builder: Builder) {
    /**
     * The data binding information for the component's properties.
     */
    val bindingProperties: Map<String, ComponentBindingPropertiesValue>? = builder.bindingProperties
    /**
     * A list of child components that are instances of the main component.
     */
    val children: List<ComponentChild>? = builder.children
    /**
     * The data binding configuration for customizing a component's properties. Use this for a
     * collection component.
     */
    val collectionProperties: Map<String, ComponentDataConfiguration>? = builder.collectionProperties
    /**
     * The component type. This can be an Amplify custom UI component or another
     * custom component.
     */
    val componentType: kotlin.String? = builder.componentType
    /**
     * The event configuration for the component. Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.
     */
    val events: Map<String, ComponentEvent>? = builder.events
    /**
     * The name of the component
     */
    val name: kotlin.String? = builder.name
    /**
     * Describes the component properties that can be overriden to customize an instance of the
     * component.
     */
    val overrides: Map<String, Map<String, String>>? = builder.overrides
    /**
     * Describes the component's properties.
     */
    val properties: Map<String, ComponentProperty>? = builder.properties
    /**
     * The schema version of the component when it was imported.
     */
    val schemaVersion: kotlin.String? = builder.schemaVersion
    /**
     * The unique ID of the component in its original source system, such as Figma.
     */
    val sourceId: kotlin.String? = builder.sourceId
    /**
     * One or more key-value pairs to use when tagging the component data.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * A list of the unique variants of this component.
     */
    val variants: List<ComponentVariant>? = builder.variants

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amplifyuibuilder.model.CreateComponentData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateComponentData(")
        append("bindingProperties=$bindingProperties,")
        append("children=$children,")
        append("collectionProperties=$collectionProperties,")
        append("componentType=$componentType,")
        append("events=$events,")
        append("name=$name,")
        append("overrides=$overrides,")
        append("properties=$properties,")
        append("schemaVersion=$schemaVersion,")
        append("sourceId=$sourceId,")
        append("tags=$tags,")
        append("variants=$variants)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bindingProperties?.hashCode() ?: 0
        result = 31 * result + (children?.hashCode() ?: 0)
        result = 31 * result + (collectionProperties?.hashCode() ?: 0)
        result = 31 * result + (componentType?.hashCode() ?: 0)
        result = 31 * result + (events?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (overrides?.hashCode() ?: 0)
        result = 31 * result + (properties?.hashCode() ?: 0)
        result = 31 * result + (schemaVersion?.hashCode() ?: 0)
        result = 31 * result + (sourceId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (variants?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateComponentData

        if (bindingProperties != other.bindingProperties) return false
        if (children != other.children) return false
        if (collectionProperties != other.collectionProperties) return false
        if (componentType != other.componentType) return false
        if (events != other.events) return false
        if (name != other.name) return false
        if (overrides != other.overrides) return false
        if (properties != other.properties) return false
        if (schemaVersion != other.schemaVersion) return false
        if (sourceId != other.sourceId) return false
        if (tags != other.tags) return false
        if (variants != other.variants) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amplifyuibuilder.model.CreateComponentData = Builder(this).apply(block).build()

    class Builder {
        /**
         * The data binding information for the component's properties.
         */
        var bindingProperties: Map<String, ComponentBindingPropertiesValue>? = null
        /**
         * A list of child components that are instances of the main component.
         */
        var children: List<ComponentChild>? = null
        /**
         * The data binding configuration for customizing a component's properties. Use this for a
         * collection component.
         */
        var collectionProperties: Map<String, ComponentDataConfiguration>? = null
        /**
         * The component type. This can be an Amplify custom UI component or another
         * custom component.
         */
        var componentType: kotlin.String? = null
        /**
         * The event configuration for the component. Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.
         */
        var events: Map<String, ComponentEvent>? = null
        /**
         * The name of the component
         */
        var name: kotlin.String? = null
        /**
         * Describes the component properties that can be overriden to customize an instance of the
         * component.
         */
        var overrides: Map<String, Map<String, String>>? = null
        /**
         * Describes the component's properties.
         */
        var properties: Map<String, ComponentProperty>? = null
        /**
         * The schema version of the component when it was imported.
         */
        var schemaVersion: kotlin.String? = null
        /**
         * The unique ID of the component in its original source system, such as Figma.
         */
        var sourceId: kotlin.String? = null
        /**
         * One or more key-value pairs to use when tagging the component data.
         */
        var tags: Map<String, String>? = null
        /**
         * A list of the unique variants of this component.
         */
        var variants: List<ComponentVariant>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amplifyuibuilder.model.CreateComponentData) : this() {
            this.bindingProperties = x.bindingProperties
            this.children = x.children
            this.collectionProperties = x.collectionProperties
            this.componentType = x.componentType
            this.events = x.events
            this.name = x.name
            this.overrides = x.overrides
            this.properties = x.properties
            this.schemaVersion = x.schemaVersion
            this.sourceId = x.sourceId
            this.tags = x.tags
            this.variants = x.variants
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amplifyuibuilder.model.CreateComponentData = CreateComponentData(this)
    }
}
