// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplifyuibuilder.model



/**
 * Updates and saves all of the information about a component, based on component ID.
 */
class UpdateComponentData private constructor(builder: Builder) {
    /**
     * The data binding information for the component's properties.
     */
    val bindingProperties: Map<String, ComponentBindingPropertiesValue>? = builder.bindingProperties
    /**
     * The components that are instances of the main component.
     */
    val children: List<ComponentChild>? = builder.children
    /**
     * The configuration for binding a component's properties to a data model. Use this for a
     * collection component.
     */
    val collectionProperties: Map<String, ComponentDataConfiguration>? = builder.collectionProperties
    /**
     * The type of the component. This can be an Amplify custom UI component or
     * another custom component.
     */
    val componentType: kotlin.String? = builder.componentType
    /**
     * The event configuration for the component. Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.
     */
    val events: Map<String, ComponentEvent>? = builder.events
    /**
     * The unique ID of the component to update.
     */
    val id: kotlin.String? = builder.id
    /**
     * The name of the component to update.
     */
    val name: kotlin.String? = builder.name
    /**
     * Describes the properties that can be overriden to customize the component.
     */
    val overrides: Map<String, Map<String, String>>? = builder.overrides
    /**
     * Describes the component's properties.
     */
    val properties: Map<String, ComponentProperty>? = builder.properties
    /**
     * The schema version of the component when it was imported.
     */
    val schemaVersion: kotlin.String? = builder.schemaVersion
    /**
     * The unique ID of the component in its original source system, such as Figma.
     */
    val sourceId: kotlin.String? = builder.sourceId
    /**
     * A list of the unique variants of the main component being updated.
     */
    val variants: List<ComponentVariant>? = builder.variants

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amplifyuibuilder.model.UpdateComponentData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateComponentData(")
        append("bindingProperties=$bindingProperties,")
        append("children=$children,")
        append("collectionProperties=$collectionProperties,")
        append("componentType=$componentType,")
        append("events=$events,")
        append("id=$id,")
        append("name=$name,")
        append("overrides=$overrides,")
        append("properties=$properties,")
        append("schemaVersion=$schemaVersion,")
        append("sourceId=$sourceId,")
        append("variants=$variants)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bindingProperties?.hashCode() ?: 0
        result = 31 * result + (children?.hashCode() ?: 0)
        result = 31 * result + (collectionProperties?.hashCode() ?: 0)
        result = 31 * result + (componentType?.hashCode() ?: 0)
        result = 31 * result + (events?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (overrides?.hashCode() ?: 0)
        result = 31 * result + (properties?.hashCode() ?: 0)
        result = 31 * result + (schemaVersion?.hashCode() ?: 0)
        result = 31 * result + (sourceId?.hashCode() ?: 0)
        result = 31 * result + (variants?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateComponentData

        if (bindingProperties != other.bindingProperties) return false
        if (children != other.children) return false
        if (collectionProperties != other.collectionProperties) return false
        if (componentType != other.componentType) return false
        if (events != other.events) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (overrides != other.overrides) return false
        if (properties != other.properties) return false
        if (schemaVersion != other.schemaVersion) return false
        if (sourceId != other.sourceId) return false
        if (variants != other.variants) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amplifyuibuilder.model.UpdateComponentData = Builder(this).apply(block).build()

    class Builder {
        /**
         * The data binding information for the component's properties.
         */
        var bindingProperties: Map<String, ComponentBindingPropertiesValue>? = null
        /**
         * The components that are instances of the main component.
         */
        var children: List<ComponentChild>? = null
        /**
         * The configuration for binding a component's properties to a data model. Use this for a
         * collection component.
         */
        var collectionProperties: Map<String, ComponentDataConfiguration>? = null
        /**
         * The type of the component. This can be an Amplify custom UI component or
         * another custom component.
         */
        var componentType: kotlin.String? = null
        /**
         * The event configuration for the component. Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.
         */
        var events: Map<String, ComponentEvent>? = null
        /**
         * The unique ID of the component to update.
         */
        var id: kotlin.String? = null
        /**
         * The name of the component to update.
         */
        var name: kotlin.String? = null
        /**
         * Describes the properties that can be overriden to customize the component.
         */
        var overrides: Map<String, Map<String, String>>? = null
        /**
         * Describes the component's properties.
         */
        var properties: Map<String, ComponentProperty>? = null
        /**
         * The schema version of the component when it was imported.
         */
        var schemaVersion: kotlin.String? = null
        /**
         * The unique ID of the component in its original source system, such as Figma.
         */
        var sourceId: kotlin.String? = null
        /**
         * A list of the unique variants of the main component being updated.
         */
        var variants: List<ComponentVariant>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amplifyuibuilder.model.UpdateComponentData) : this() {
            this.bindingProperties = x.bindingProperties
            this.children = x.children
            this.collectionProperties = x.collectionProperties
            this.componentType = x.componentType
            this.events = x.events
            this.id = x.id
            this.name = x.name
            this.overrides = x.overrides
            this.properties = x.properties
            this.schemaVersion = x.schemaVersion
            this.sourceId = x.sourceId
            this.variants = x.variants
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amplifyuibuilder.model.UpdateComponentData = UpdateComponentData(this)
    }
}
