// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplifyuibuilder.transform

import aws.sdk.kotlin.services.amplifyuibuilder.model.CreateThemeData
import aws.sdk.kotlin.services.amplifyuibuilder.model.CreateThemeRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.parameters
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel


internal class CreateThemeOperationSerializer: HttpSerialize<CreateThemeRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateThemeRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "app",
                "${input.appId}".encodeLabel(),
                "environment",
                "${input.environmentName}".encodeLabel(),
                "themes",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                append("clientToken", (input.clientToken ?: context.idempotencyTokenProvider.generateToken()))
            }
        }

        if (input.themeToCreate != null) {
            val payload = serializeCreateThemeDataPayload(input.themeToCreate)
            builder.body = ByteArrayContent(payload)
        }
        builder.headers.setMissing("Content-Type", "application/json")
        if (input.themeToCreate == null) {
            builder.body = ByteArrayContent("{}".encodeToByteArray())
        }
        return builder
    }
}
