// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * The POST Request to add a new RestApi resource to your collection.
 */
class CreateRestApiRequest private constructor(builder: Builder) {
    /**
     * The source of the API key for metering requests according to a usage plan. Valid values are:
     * + `HEADER` to read the API key from the `X-API-Key` header of a request.
     * + `AUTHORIZER` to read the API key from the `UsageIdentifierKey` from a custom authorizer.
     */
    val apiKeySource: aws.sdk.kotlin.services.apigateway.model.ApiKeySourceType? = builder.apiKeySource
    /**
     * The list of binary media types supported by the RestApi. By default, the RestApi supports only UTF-8-encoded text payloads.
     */
    val binaryMediaTypes: List<String>? = builder.binaryMediaTypes
    /**
     * The ID of the RestApi that you want to clone from.
     */
    val cloneFrom: kotlin.String? = builder.cloneFrom
    /**
     * The description of the RestApi.
     */
    val description: kotlin.String? = builder.description
    /**
     * Specifies whether clients can invoke your API by using the default `execute-api` endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.
     */
    val disableExecuteApiEndpoint: kotlin.Boolean = builder.disableExecuteApiEndpoint
    /**
     * The endpoint configuration of this RestApi showing the endpoint types of the API.
     */
    val endpointConfiguration: aws.sdk.kotlin.services.apigateway.model.EndpointConfiguration? = builder.endpointConfiguration
    /**
     * A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.
     */
    val minimumCompressionSize: kotlin.Int? = builder.minimumCompressionSize
    /**
     * &#91;Required&#93; The name of the RestApi.
     */
    val name: kotlin.String? = builder.name
    /**
     * A stringified JSON policy document that applies to this RestApi regardless of the caller and Method configuration.
     */
    val policy: kotlin.String? = builder.policy
    /**
     * The key-value map of strings. The valid character set is &#91;a-zA-Z+-=._:/&#93;. The tag key can be up to 128 characters and must not start with `aws:`. The tag value can be up to 256 characters.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * A version identifier for the API.
     */
    val version: kotlin.String? = builder.version

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.CreateRestApiRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRestApiRequest(")
        append("apiKeySource=$apiKeySource,")
        append("binaryMediaTypes=$binaryMediaTypes,")
        append("cloneFrom=$cloneFrom,")
        append("description=$description,")
        append("disableExecuteApiEndpoint=$disableExecuteApiEndpoint,")
        append("endpointConfiguration=$endpointConfiguration,")
        append("minimumCompressionSize=$minimumCompressionSize,")
        append("name=$name,")
        append("policy=$policy,")
        append("tags=$tags,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiKeySource?.hashCode() ?: 0
        result = 31 * result + (binaryMediaTypes?.hashCode() ?: 0)
        result = 31 * result + (cloneFrom?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (disableExecuteApiEndpoint.hashCode())
        result = 31 * result + (endpointConfiguration?.hashCode() ?: 0)
        result = 31 * result + (minimumCompressionSize ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (policy?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateRestApiRequest

        if (apiKeySource != other.apiKeySource) return false
        if (binaryMediaTypes != other.binaryMediaTypes) return false
        if (cloneFrom != other.cloneFrom) return false
        if (description != other.description) return false
        if (disableExecuteApiEndpoint != other.disableExecuteApiEndpoint) return false
        if (endpointConfiguration != other.endpointConfiguration) return false
        if (minimumCompressionSize != other.minimumCompressionSize) return false
        if (name != other.name) return false
        if (policy != other.policy) return false
        if (tags != other.tags) return false
        if (version != other.version) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.CreateRestApiRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The source of the API key for metering requests according to a usage plan. Valid values are:
         * + `HEADER` to read the API key from the `X-API-Key` header of a request.
         * + `AUTHORIZER` to read the API key from the `UsageIdentifierKey` from a custom authorizer.
         */
        var apiKeySource: aws.sdk.kotlin.services.apigateway.model.ApiKeySourceType? = null
        /**
         * The list of binary media types supported by the RestApi. By default, the RestApi supports only UTF-8-encoded text payloads.
         */
        var binaryMediaTypes: List<String>? = null
        /**
         * The ID of the RestApi that you want to clone from.
         */
        var cloneFrom: kotlin.String? = null
        /**
         * The description of the RestApi.
         */
        var description: kotlin.String? = null
        /**
         * Specifies whether clients can invoke your API by using the default `execute-api` endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.
         */
        var disableExecuteApiEndpoint: kotlin.Boolean = false
        /**
         * The endpoint configuration of this RestApi showing the endpoint types of the API.
         */
        var endpointConfiguration: aws.sdk.kotlin.services.apigateway.model.EndpointConfiguration? = null
        /**
         * A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.
         */
        var minimumCompressionSize: kotlin.Int? = null
        /**
         * &#91;Required&#93; The name of the RestApi.
         */
        var name: kotlin.String? = null
        /**
         * A stringified JSON policy document that applies to this RestApi regardless of the caller and Method configuration.
         */
        var policy: kotlin.String? = null
        /**
         * The key-value map of strings. The valid character set is &#91;a-zA-Z+-=._:/&#93;. The tag key can be up to 128 characters and must not start with `aws:`. The tag value can be up to 256 characters.
         */
        var tags: Map<String, String>? = null
        /**
         * A version identifier for the API.
         */
        var version: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.CreateRestApiRequest) : this() {
            this.apiKeySource = x.apiKeySource
            this.binaryMediaTypes = x.binaryMediaTypes
            this.cloneFrom = x.cloneFrom
            this.description = x.description
            this.disableExecuteApiEndpoint = x.disableExecuteApiEndpoint
            this.endpointConfiguration = x.endpointConfiguration
            this.minimumCompressionSize = x.minimumCompressionSize
            this.name = x.name
            this.policy = x.policy
            this.tags = x.tags
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.CreateRestApiRequest = CreateRestApiRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.EndpointConfiguration] inside the given [block]
         */
        fun endpointConfiguration(block: aws.sdk.kotlin.services.apigateway.model.EndpointConfiguration.Builder.() -> kotlin.Unit) {
            this.endpointConfiguration = aws.sdk.kotlin.services.apigateway.model.EndpointConfiguration.invoke(block)
        }
    }
}
