// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * An API Gateway VPC link for a RestApi to access resources in an Amazon Virtual Private Cloud (VPC).
 *
 * To enable access to a resource in an Amazon Virtual Private Cloud through Amazon API Gateway, you, as an API developer, create a VpcLink resource targeted for one or more network load balancers of the VPC and then integrate an API method with a private integration that uses the VpcLink. The private integration has an integration type of `HTTP` or `HTTP_PROXY` and has a connection type of `VPC_LINK`. The integration uses the `connectionId` property to identify the VpcLink used.
 */
class CreateVpcLinkResponse private constructor(builder: Builder) {
    /**
     * The description of the VPC link.
     */
    val description: kotlin.String? = builder.description
    /**
     * The identifier of the VpcLink. It is used in an Integration to reference this VpcLink.
     */
    val id: kotlin.String? = builder.id
    /**
     * The name used to label and identify the VPC link.
     */
    val name: kotlin.String? = builder.name
    /**
     * The status of the VPC link. The valid values are `AVAILABLE`, `PENDING`, `DELETING`, or `FAILED`. Deploying an API will wait if the status is `PENDING` and will fail if the status is `DELETING`.
     */
    val status: aws.sdk.kotlin.services.apigateway.model.VpcLinkStatus? = builder.status
    /**
     * A description about the VPC link status.
     */
    val statusMessage: kotlin.String? = builder.statusMessage
    /**
     * The collection of tags. Each tag element is associated with a given resource.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.
     */
    val targetArns: List<String>? = builder.targetArns

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.CreateVpcLinkResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateVpcLinkResponse(")
        append("description=$description,")
        append("id=$id,")
        append("name=$name,")
        append("status=$status,")
        append("statusMessage=$statusMessage,")
        append("tags=$tags,")
        append("targetArns=$targetArns)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetArns?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateVpcLinkResponse

        if (description != other.description) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false
        if (tags != other.tags) return false
        if (targetArns != other.targetArns) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.CreateVpcLinkResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The description of the VPC link.
         */
        var description: kotlin.String? = null
        /**
         * The identifier of the VpcLink. It is used in an Integration to reference this VpcLink.
         */
        var id: kotlin.String? = null
        /**
         * The name used to label and identify the VPC link.
         */
        var name: kotlin.String? = null
        /**
         * The status of the VPC link. The valid values are `AVAILABLE`, `PENDING`, `DELETING`, or `FAILED`. Deploying an API will wait if the status is `PENDING` and will fail if the status is `DELETING`.
         */
        var status: aws.sdk.kotlin.services.apigateway.model.VpcLinkStatus? = null
        /**
         * A description about the VPC link status.
         */
        var statusMessage: kotlin.String? = null
        /**
         * The collection of tags. Each tag element is associated with a given resource.
         */
        var tags: Map<String, String>? = null
        /**
         * The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.
         */
        var targetArns: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.CreateVpcLinkResponse) : this() {
            this.description = x.description
            this.id = x.id
            this.name = x.name
            this.status = x.status
            this.statusMessage = x.statusMessage
            this.tags = x.tags
            this.targetArns = x.targetArns
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.CreateVpcLinkResponse = CreateVpcLinkResponse(this)
    }
}
