// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Represents an AWS account that is associated with API Gateway.
 *
 * To view the account info, call `GET` on this resource.
 *
 * <h4>Error CodesThe following exception may be thrown when the request fails.
 * + UnauthorizedException
 * + NotFoundException
 * + TooManyRequestsException
 * For detailed error code information, including the corresponding HTTP Status Codes, see [API Gateway Error Codes](https://docs.aws.amazon.com/apigateway/api-reference/handling-errors/#api-error-codes)
 *
 * <h4>Example: Get the information about an account.<h5>Request`<code>GET /account HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com X-Amz-Date: 20160531T184618Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash} </code>`<h5>ResponseThe successful response returns a `200 OK` status code and a payload similar to the following:
 *
 * `<code>{ "_links": { "curies": { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/account-apigateway-{rel}.html", "name": "account", "templated": true }, "self": { "href": "/account" }, "account:update": { "href": "/account" } }, "cloudwatchRoleArn": "arn:aws:iam::123456789012:role/apigAwsProxyRole", "throttleSettings": { "rateLimit": 500, "burstLimit": 1000 } } </code>`In addition to making the REST API call directly, you can use the AWS CLI and an AWS SDK to access this resource.
 *
 * [API Gateway Limits](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-limits.html)[Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/welcome.html), [AWS CLI](https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-account.html)
 */
class GetAccountResponse private constructor(builder: Builder) {
    /**
     * The version of the API keys used for the account.
     */
    val apiKeyVersion: kotlin.String? = builder.apiKeyVersion
    /**
     * The ARN of an Amazon CloudWatch role for the current Account.
     */
    val cloudwatchRoleArn: kotlin.String? = builder.cloudwatchRoleArn
    /**
     * A list of features supported for the account. When usage plans are enabled, the features list will include an entry of `"UsagePlans"`.
     */
    val features: List<String>? = builder.features
    /**
     * Specifies the API request limits configured for the current Account.
     */
    val throttleSettings: aws.sdk.kotlin.services.apigateway.model.ThrottleSettings? = builder.throttleSettings

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.GetAccountResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetAccountResponse(")
        append("apiKeyVersion=$apiKeyVersion,")
        append("cloudwatchRoleArn=$cloudwatchRoleArn,")
        append("features=$features,")
        append("throttleSettings=$throttleSettings)")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiKeyVersion?.hashCode() ?: 0
        result = 31 * result + (cloudwatchRoleArn?.hashCode() ?: 0)
        result = 31 * result + (features?.hashCode() ?: 0)
        result = 31 * result + (throttleSettings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetAccountResponse

        if (apiKeyVersion != other.apiKeyVersion) return false
        if (cloudwatchRoleArn != other.cloudwatchRoleArn) return false
        if (features != other.features) return false
        if (throttleSettings != other.throttleSettings) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.GetAccountResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The version of the API keys used for the account.
         */
        var apiKeyVersion: kotlin.String? = null
        /**
         * The ARN of an Amazon CloudWatch role for the current Account.
         */
        var cloudwatchRoleArn: kotlin.String? = null
        /**
         * A list of features supported for the account. When usage plans are enabled, the features list will include an entry of `"UsagePlans"`.
         */
        var features: List<String>? = null
        /**
         * Specifies the API request limits configured for the current Account.
         */
        var throttleSettings: aws.sdk.kotlin.services.apigateway.model.ThrottleSettings? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.GetAccountResponse) : this() {
            this.apiKeyVersion = x.apiKeyVersion
            this.cloudwatchRoleArn = x.cloudwatchRoleArn
            this.features = x.features
            this.throttleSettings = x.throttleSettings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.GetAccountResponse = GetAccountResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.ThrottleSettings] inside the given [block]
         */
        fun throttleSettings(block: aws.sdk.kotlin.services.apigateway.model.ThrottleSettings.Builder.() -> kotlin.Unit) {
            this.throttleSettings = aws.sdk.kotlin.services.apigateway.model.ThrottleSettings.invoke(block)
        }
    }
}
