// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Represents a collection resource that contains zero or more references to your existing deployments, and links that guide you on how to interact with your collection. The collection offers a paginated view of the contained deployments.
 *
 * To create a new deployment of a RestApi, make a `POST` request against this resource. To view, update, or delete an existing deployment, make a `GET`, `PATCH`, or `DELETE` request, respectively, on a specified Deployment resource.
 *
 * [Deploying an API](https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-deploy-api.html), [AWS CLI](https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-deployment.html), [AWS SDKs](https://aws.amazon.com/tools/)
 */
class GetDeploymentsResponse private constructor(builder: Builder) {
    /**
     * The current page of elements from this collection.
     */
    val items: List<Deployment>? = builder.items
    /**
     * The current pagination position in the paged result set.
     */
    val position: kotlin.String? = builder.position

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.GetDeploymentsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetDeploymentsResponse(")
        append("items=$items,")
        append("position=$position)")
    }

    override fun hashCode(): kotlin.Int {
        var result = items?.hashCode() ?: 0
        result = 31 * result + (position?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetDeploymentsResponse

        if (items != other.items) return false
        if (position != other.position) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.GetDeploymentsResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The current page of elements from this collection.
         */
        var items: List<Deployment>? = null
        /**
         * The current pagination position in the paged result set.
         */
        var position: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.GetDeploymentsResponse) : this() {
            this.items = x.items
            this.position = x.position
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.GetDeploymentsResponse = GetDeploymentsResponse(this)
    }
}
