// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Gets the documentation parts of an API. The result may be filtered by the type, name, or path of API entities (targets).
 */
class GetDocumentationPartsRequest private constructor(builder: Builder) {
    /**
     * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
     */
    val limit: kotlin.Int? = builder.limit
    /**
     * The status of the API documentation parts to retrieve. Valid values are `DOCUMENTED` for retrieving DocumentationPart resources with content and `UNDOCUMENTED` for DocumentationPart resources without content.
     */
    val locationStatus: aws.sdk.kotlin.services.apigateway.model.LocationStatusType? = builder.locationStatus
    /**
     * The name of API entities of the to-be-retrieved documentation parts.
     */
    val nameQuery: kotlin.String? = builder.nameQuery
    /**
     * The path of API entities of the to-be-retrieved documentation parts.
     */
    val path: kotlin.String? = builder.path
    /**
     * The current pagination position in the paged result set.
     */
    val position: kotlin.String? = builder.position
    /**
     * &#91;Required&#93; The string identifier of the associated RestApi.
     */
    val restApiId: kotlin.String? = builder.restApiId
    /**
     * The type of API entities of the to-be-retrieved documentation parts.
     */
    val type: aws.sdk.kotlin.services.apigateway.model.DocumentationPartType? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.GetDocumentationPartsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetDocumentationPartsRequest(")
        append("limit=$limit,")
        append("locationStatus=$locationStatus,")
        append("nameQuery=$nameQuery,")
        append("path=$path,")
        append("position=$position,")
        append("restApiId=$restApiId,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = limit ?: 0
        result = 31 * result + (locationStatus?.hashCode() ?: 0)
        result = 31 * result + (nameQuery?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (position?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetDocumentationPartsRequest

        if (limit != other.limit) return false
        if (locationStatus != other.locationStatus) return false
        if (nameQuery != other.nameQuery) return false
        if (path != other.path) return false
        if (position != other.position) return false
        if (restApiId != other.restApiId) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.GetDocumentationPartsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
         */
        var limit: kotlin.Int? = null
        /**
         * The status of the API documentation parts to retrieve. Valid values are `DOCUMENTED` for retrieving DocumentationPart resources with content and `UNDOCUMENTED` for DocumentationPart resources without content.
         */
        var locationStatus: aws.sdk.kotlin.services.apigateway.model.LocationStatusType? = null
        /**
         * The name of API entities of the to-be-retrieved documentation parts.
         */
        var nameQuery: kotlin.String? = null
        /**
         * The path of API entities of the to-be-retrieved documentation parts.
         */
        var path: kotlin.String? = null
        /**
         * The current pagination position in the paged result set.
         */
        var position: kotlin.String? = null
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        var restApiId: kotlin.String? = null
        /**
         * The type of API entities of the to-be-retrieved documentation parts.
         */
        var type: aws.sdk.kotlin.services.apigateway.model.DocumentationPartType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.GetDocumentationPartsRequest) : this() {
            this.limit = x.limit
            this.locationStatus = x.locationStatus
            this.nameQuery = x.nameQuery
            this.path = x.path
            this.position = x.position
            this.restApiId = x.restApiId
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.GetDocumentationPartsRequest = GetDocumentationPartsRequest(this)
    }
}
