// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Represents the data structure of a method's request or response payload.
 *
 * A request model defines the data structure of the client-supplied request payload. A response model defines the data structure of the response payload returned by the back end. Although not required, models are useful for mapping payloads between the front end and back end.
 *
 * A model is used for generating an API's SDK, validating the input request body, and creating a skeletal mapping template.
 *
 * Method, MethodResponse, [Models and Mappings](https://docs.aws.amazon.com/apigateway/latest/developerguide/models-mappings.html)
 */
class GetModelResponse private constructor(builder: Builder) {
    /**
     * The content-type for the model.
     */
    val contentType: kotlin.String? = builder.contentType
    /**
     * The description of the model.
     */
    val description: kotlin.String? = builder.description
    /**
     * The identifier for the model resource.
     */
    val id: kotlin.String? = builder.id
    /**
     * The name of the model. Must be an alphanumeric string.
     */
    val name: kotlin.String? = builder.name
    /**
     * The schema for the model. For `application/json` models, this should be [JSON schema draft 4](https://tools.ietf.org/html/draft-zyp-json-schema-04) model. Do not include "\*&#47;" characters in the description of any properties because such "\*&#47;" characters may be interpreted as the closing marker for comments in some languages, such as Java or JavaScript, causing the installation of your API's SDK generated by API Gateway to fail.
     */
    val schema: kotlin.String? = builder.schema

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.GetModelResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetModelResponse(")
        append("contentType=$contentType,")
        append("description=$description,")
        append("id=$id,")
        append("name=$name,")
        append("schema=$schema)")
    }

    override fun hashCode(): kotlin.Int {
        var result = contentType?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (schema?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetModelResponse

        if (contentType != other.contentType) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (schema != other.schema) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.GetModelResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The content-type for the model.
         */
        var contentType: kotlin.String? = null
        /**
         * The description of the model.
         */
        var description: kotlin.String? = null
        /**
         * The identifier for the model resource.
         */
        var id: kotlin.String? = null
        /**
         * The name of the model. Must be an alphanumeric string.
         */
        var name: kotlin.String? = null
        /**
         * The schema for the model. For `application/json` models, this should be [JSON schema draft 4](https://tools.ietf.org/html/draft-zyp-json-schema-04) model. Do not include "\*&#47;" characters in the description of any properties because such "\*&#47;" characters may be interpreted as the closing marker for comments in some languages, such as Java or JavaScript, causing the installation of your API's SDK generated by API Gateway to fail.
         */
        var schema: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.GetModelResponse) : this() {
            this.contentType = x.contentType
            this.description = x.description
            this.id = x.id
            this.name = x.name
            this.schema = x.schema
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.GetModelResponse = GetModelResponse(this)
    }
}
