// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Request to list information about a collection of resources.
 */
class GetResourcesRequest private constructor(builder: Builder) {
    /**
     * A query parameter used to retrieve the specified resources embedded in the returned Resources resource in the response. This `embed` parameter value is a list of comma-separated strings. Currently, the request supports only retrieval of the embedded Method resources this way. The query parameter value must be a single-valued list and contain the `"methods"` string. For example, `GET /restapis/{restapi_id}/resources?embed=methods`.
     */
    val embed: List<String>? = builder.embed
    /**
     * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
     */
    val limit: kotlin.Int? = builder.limit
    /**
     * The current pagination position in the paged result set.
     */
    val position: kotlin.String? = builder.position
    /**
     * &#91;Required&#93; The string identifier of the associated RestApi.
     */
    val restApiId: kotlin.String? = builder.restApiId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.GetResourcesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetResourcesRequest(")
        append("embed=$embed,")
        append("limit=$limit,")
        append("position=$position,")
        append("restApiId=$restApiId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = embed?.hashCode() ?: 0
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (position?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetResourcesRequest

        if (embed != other.embed) return false
        if (limit != other.limit) return false
        if (position != other.position) return false
        if (restApiId != other.restApiId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.GetResourcesRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A query parameter used to retrieve the specified resources embedded in the returned Resources resource in the response. This `embed` parameter value is a list of comma-separated strings. Currently, the request supports only retrieval of the embedded Method resources this way. The query parameter value must be a single-valued list and contain the `"methods"` string. For example, `GET /restapis/{restapi_id}/resources?embed=methods`.
         */
        var embed: List<String>? = null
        /**
         * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
         */
        var limit: kotlin.Int? = null
        /**
         * The current pagination position in the paged result set.
         */
        var position: kotlin.String? = null
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        var restApiId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.GetResourcesRequest) : this() {
            this.embed = x.embed
            this.limit = x.limit
            this.position = x.position
            this.restApiId = x.restApiId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.GetResourcesRequest = GetResourcesRequest(this)
    }
}
