// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * A POST request to import an API to API Gateway using an input of an API definition file.
 */
class ImportRestApiRequest private constructor(builder: Builder) {
    /**
     * &#91;Required&#93; The POST request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.
     */
    val body: kotlin.ByteArray? = builder.body
    /**
     * A query parameter to indicate whether to rollback the API creation (`true`) or not (`false`) when a warning is encountered. The default value is `false`.
     */
    val failOnWarnings: kotlin.Boolean = builder.failOnWarnings
    /**
     * A key-value map of context-specific query string parameters specifying the behavior of different API importing operations. The following shows operation-specific parameters and their supported values.
     *
     *  To exclude DocumentationParts from the import, set `parameters` as `ignore=documentation`.
     *
     *  To configure the endpoint type, set `parameters` as `endpointConfigurationTypes=EDGE`, `endpointConfigurationTypes=REGIONAL`, or `endpointConfigurationTypes=PRIVATE`. The default endpoint type is `EDGE`.
     *
     *  To handle imported `basepath`, set `parameters` as `basepath=ignore`, `basepath=prepend` or `basepath=split`.
     *
     * For example, the AWS CLI command to exclude documentation from the imported API is:
     *
     * `<code>aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'</code>`The AWS CLI command to set the regional endpoint on the imported API is:
     *
     * `<code>aws apigateway import-rest-api --parameters endpointConfigurationTypes=REGIONAL --body 'file:///path/to/imported-api-body.json'</code>`
     */
    val parameters: Map<String, String>? = builder.parameters

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.ImportRestApiRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImportRestApiRequest(")
        append("body=$body,")
        append("failOnWarnings=$failOnWarnings,")
        append("parameters=$parameters)")
    }

    override fun hashCode(): kotlin.Int {
        var result = body?.contentHashCode() ?: 0
        result = 31 * result + (failOnWarnings.hashCode())
        result = 31 * result + (parameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImportRestApiRequest

        if (body != null) {
            if (other.body == null) return false
            if (!body.contentEquals(other.body)) return false
        } else if (other.body != null) return false
        if (failOnWarnings != other.failOnWarnings) return false
        if (parameters != other.parameters) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.ImportRestApiRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * &#91;Required&#93; The POST request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.
         */
        var body: kotlin.ByteArray? = null
        /**
         * A query parameter to indicate whether to rollback the API creation (`true`) or not (`false`) when a warning is encountered. The default value is `false`.
         */
        var failOnWarnings: kotlin.Boolean = false
        /**
         * A key-value map of context-specific query string parameters specifying the behavior of different API importing operations. The following shows operation-specific parameters and their supported values.
         *
         *  To exclude DocumentationParts from the import, set `parameters` as `ignore=documentation`.
         *
         *  To configure the endpoint type, set `parameters` as `endpointConfigurationTypes=EDGE`, `endpointConfigurationTypes=REGIONAL`, or `endpointConfigurationTypes=PRIVATE`. The default endpoint type is `EDGE`.
         *
         *  To handle imported `basepath`, set `parameters` as `basepath=ignore`, `basepath=prepend` or `basepath=split`.
         *
         * For example, the AWS CLI command to exclude documentation from the imported API is:
         *
         * `<code>aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'</code>`The AWS CLI command to set the regional endpoint on the imported API is:
         *
         * `<code>aws apigateway import-rest-api --parameters endpointConfigurationTypes=REGIONAL --body 'file:///path/to/imported-api-body.json'</code>`
         */
        var parameters: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.ImportRestApiRequest) : this() {
            this.body = x.body
            this.failOnWarnings = x.failOnWarnings
            this.parameters = x.parameters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.ImportRestApiRequest = ImportRestApiRequest(this)
    }
}
