// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Creates a customization of a GatewayResponse of a specified response type and status code on the given RestApi.
 */
class PutGatewayResponseRequest private constructor(builder: Builder) {
    /**
     * Response parameters (paths, query strings and headers) of the GatewayResponse as a string-to-string map of key-value pairs.
     */
    val responseParameters: Map<String, String>? = builder.responseParameters
    /**
     * Response templates of the GatewayResponse as a string-to-string map of key-value pairs.
     */
    val responseTemplates: Map<String, String>? = builder.responseTemplates
    /**
     * &#91;Required&#93;
     *
     * The response type of the associated GatewayResponse.
     */
    val responseType: aws.sdk.kotlin.services.apigateway.model.GatewayResponseType? = builder.responseType
    /**
     * &#91;Required&#93; The string identifier of the associated RestApi.
     */
    val restApiId: kotlin.String? = builder.restApiId
    /**
     * The HTTP status code of the GatewayResponse.
     */
    val statusCode: kotlin.String? = builder.statusCode

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.PutGatewayResponseRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutGatewayResponseRequest(")
        append("responseParameters=$responseParameters,")
        append("responseTemplates=$responseTemplates,")
        append("responseType=$responseType,")
        append("restApiId=$restApiId,")
        append("statusCode=$statusCode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = responseParameters?.hashCode() ?: 0
        result = 31 * result + (responseTemplates?.hashCode() ?: 0)
        result = 31 * result + (responseType?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        result = 31 * result + (statusCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutGatewayResponseRequest

        if (responseParameters != other.responseParameters) return false
        if (responseTemplates != other.responseTemplates) return false
        if (responseType != other.responseType) return false
        if (restApiId != other.restApiId) return false
        if (statusCode != other.statusCode) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.PutGatewayResponseRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Response parameters (paths, query strings and headers) of the GatewayResponse as a string-to-string map of key-value pairs.
         */
        var responseParameters: Map<String, String>? = null
        /**
         * Response templates of the GatewayResponse as a string-to-string map of key-value pairs.
         */
        var responseTemplates: Map<String, String>? = null
        /**
         * &#91;Required&#93;
         *
         * The response type of the associated GatewayResponse.
         */
        var responseType: aws.sdk.kotlin.services.apigateway.model.GatewayResponseType? = null
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        var restApiId: kotlin.String? = null
        /**
         * The HTTP status code of the GatewayResponse.
         */
        var statusCode: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.PutGatewayResponseRequest) : this() {
            this.responseParameters = x.responseParameters
            this.responseTemplates = x.responseTemplates
            this.responseType = x.responseType
            this.restApiId = x.restApiId
            this.statusCode = x.statusCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.PutGatewayResponseRequest = PutGatewayResponseRequest(this)
    }
}
