// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Sets up a method's integration.
 */
class PutIntegrationRequest private constructor(builder: Builder) {
    /**
     * A list of request parameters whose values API Gateway caches. To be valid values for `cacheKeyParameters`, these parameters must also be specified for Method`requestParameters`.
     */
    val cacheKeyParameters: List<String>? = builder.cacheKeyParameters
    /**
     * Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the `cacheNamespace`. You can specify the same `cacheNamespace` across resources to return the same cached data for requests to different resources.
     */
    val cacheNamespace: kotlin.String? = builder.cacheNamespace
    /**
     * The (`id`[](https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id)) of the VpcLink used for the integration when `connectionType=VPC_LINK` and undefined, otherwise.
     */
    val connectionId: kotlin.String? = builder.connectionId
    /**
     * The type of the network connection to the integration endpoint. The valid value is `INTERNET` for connections through the public routable internet or `VPC_LINK` for private connections between API Gateway and a network load balancer in a VPC. The default value is `INTERNET`.
     */
    val connectionType: aws.sdk.kotlin.services.apigateway.model.ConnectionType? = builder.connectionType
    /**
     * Specifies how to handle request payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`, with the following behaviors:
     * + `CONVERT_TO_BINARY`: Converts a request payload from a Base64-encoded string to the corresponding binary blob.
     * + `CONVERT_TO_TEXT`: Converts a request payload from a binary blob to a Base64-encoded string.
     *
     * If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the `passthroughBehavior` is configured to support payload pass-through.
     */
    val contentHandling: aws.sdk.kotlin.services.apigateway.model.ContentHandlingStrategy? = builder.contentHandling
    /**
     * Specifies whether credentials are required for a put integration.
     */
    val credentials: kotlin.String? = builder.credentials
    /**
     * &#91;Required&#93; Specifies a put integration request's HTTP method.
     */
    val httpMethod: kotlin.String? = builder.httpMethod
    /**
     * Specifies a put integration HTTP method. When the integration type is HTTP or AWS, this field is required.
     */
    val integrationHttpMethod: kotlin.String? = builder.integrationHttpMethod
    /**
     * Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the `requestTemplates` property on the Integration resource. There are three valid values: `WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, and `NEVER`.
     * + `WHEN_NO_MATCH` passes the request body for unmapped content types through to the integration back end without transformation.
     * + `NEVER` rejects unmapped content types with an HTTP 415 'Unsupported Media Type' response.
     * + `WHEN_NO_TEMPLATES` allows pass-through when the integration has NO content types mapped to templates. However if there is at least one content type defined, unmapped content types will be rejected with the same 415 response.
     */
    val passthroughBehavior: kotlin.String? = builder.passthroughBehavior
    /**
     * A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of `method.request.{location}.{name}`, where `location` is `querystring`, `path`, or `header` and `name` must be a valid and unique method request parameter name.
     */
    val requestParameters: Map<String, String>? = builder.requestParameters
    /**
     * Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.
     */
    val requestTemplates: Map<String, String>? = builder.requestTemplates
    /**
     * &#91;Required&#93; Specifies a put integration request's resource ID.
     */
    val resourceId: kotlin.String? = builder.resourceId
    /**
     * &#91;Required&#93; The string identifier of the associated RestApi.
     */
    val restApiId: kotlin.String? = builder.restApiId
    /**
     * Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.
     */
    val timeoutInMillis: kotlin.Int? = builder.timeoutInMillis
    val tlsConfig: aws.sdk.kotlin.services.apigateway.model.TlsConfig? = builder.tlsConfig
    /**
     * &#91;Required&#93; Specifies a put integration input's type.
     */
    val type: aws.sdk.kotlin.services.apigateway.model.IntegrationType? = builder.type
    /**
     * Specifies Uniform Resource Identifier (URI) of the integration endpoint.
     * +  For `HTTP` or `HTTP_PROXY` integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the [RFC-3986 specification](https://en.wikipedia.org/wiki/Uniform_Resource_Identifier), for either standard integration, where `connectionType` is not `VPC_LINK`, or private integration, where `connectionType` is `VPC_LINK`. For a private HTTP integration, the URI is not used for routing.
     * +  For `AWS` or `AWS_PROXY` integrations, the URI is of the form `arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}`. Here, `{Region}` is the API Gateway region (e.g., `us-east-1`); `{service}` is the name of the integrated AWS service (e.g., `s3`); and `{subdomain}` is a designated subdomain supported by certain AWS service for fast host-name lookup. `action` can be used for an AWS service action-based API, using an `Action={name}&{p1}={v1}&p2={v2}...` query string. The ensuing `{service_api}` refers to a supported action `{name}` plus any required input parameters. Alternatively, `path` can be used for an AWS service path-based API. The ensuing `service_api` refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of `<a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a>`, the `uri` can be either `arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}` or `arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}`
     */
    val uri: kotlin.String? = builder.uri

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.PutIntegrationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutIntegrationRequest(")
        append("cacheKeyParameters=$cacheKeyParameters,")
        append("cacheNamespace=$cacheNamespace,")
        append("connectionId=$connectionId,")
        append("connectionType=$connectionType,")
        append("contentHandling=$contentHandling,")
        append("credentials=$credentials,")
        append("httpMethod=$httpMethod,")
        append("integrationHttpMethod=$integrationHttpMethod,")
        append("passthroughBehavior=$passthroughBehavior,")
        append("requestParameters=$requestParameters,")
        append("requestTemplates=$requestTemplates,")
        append("resourceId=$resourceId,")
        append("restApiId=$restApiId,")
        append("timeoutInMillis=$timeoutInMillis,")
        append("tlsConfig=$tlsConfig,")
        append("type=$type,")
        append("uri=$uri)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cacheKeyParameters?.hashCode() ?: 0
        result = 31 * result + (cacheNamespace?.hashCode() ?: 0)
        result = 31 * result + (connectionId?.hashCode() ?: 0)
        result = 31 * result + (connectionType?.hashCode() ?: 0)
        result = 31 * result + (contentHandling?.hashCode() ?: 0)
        result = 31 * result + (credentials?.hashCode() ?: 0)
        result = 31 * result + (httpMethod?.hashCode() ?: 0)
        result = 31 * result + (integrationHttpMethod?.hashCode() ?: 0)
        result = 31 * result + (passthroughBehavior?.hashCode() ?: 0)
        result = 31 * result + (requestParameters?.hashCode() ?: 0)
        result = 31 * result + (requestTemplates?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        result = 31 * result + (timeoutInMillis ?: 0)
        result = 31 * result + (tlsConfig?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (uri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutIntegrationRequest

        if (cacheKeyParameters != other.cacheKeyParameters) return false
        if (cacheNamespace != other.cacheNamespace) return false
        if (connectionId != other.connectionId) return false
        if (connectionType != other.connectionType) return false
        if (contentHandling != other.contentHandling) return false
        if (credentials != other.credentials) return false
        if (httpMethod != other.httpMethod) return false
        if (integrationHttpMethod != other.integrationHttpMethod) return false
        if (passthroughBehavior != other.passthroughBehavior) return false
        if (requestParameters != other.requestParameters) return false
        if (requestTemplates != other.requestTemplates) return false
        if (resourceId != other.resourceId) return false
        if (restApiId != other.restApiId) return false
        if (timeoutInMillis != other.timeoutInMillis) return false
        if (tlsConfig != other.tlsConfig) return false
        if (type != other.type) return false
        if (uri != other.uri) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.PutIntegrationRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of request parameters whose values API Gateway caches. To be valid values for `cacheKeyParameters`, these parameters must also be specified for Method`requestParameters`.
         */
        var cacheKeyParameters: List<String>? = null
        /**
         * Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the `cacheNamespace`. You can specify the same `cacheNamespace` across resources to return the same cached data for requests to different resources.
         */
        var cacheNamespace: kotlin.String? = null
        /**
         * The (`id`[](https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id)) of the VpcLink used for the integration when `connectionType=VPC_LINK` and undefined, otherwise.
         */
        var connectionId: kotlin.String? = null
        /**
         * The type of the network connection to the integration endpoint. The valid value is `INTERNET` for connections through the public routable internet or `VPC_LINK` for private connections between API Gateway and a network load balancer in a VPC. The default value is `INTERNET`.
         */
        var connectionType: aws.sdk.kotlin.services.apigateway.model.ConnectionType? = null
        /**
         * Specifies how to handle request payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`, with the following behaviors:
         * + `CONVERT_TO_BINARY`: Converts a request payload from a Base64-encoded string to the corresponding binary blob.
         * + `CONVERT_TO_TEXT`: Converts a request payload from a binary blob to a Base64-encoded string.
         *
         * If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the `passthroughBehavior` is configured to support payload pass-through.
         */
        var contentHandling: aws.sdk.kotlin.services.apigateway.model.ContentHandlingStrategy? = null
        /**
         * Specifies whether credentials are required for a put integration.
         */
        var credentials: kotlin.String? = null
        /**
         * &#91;Required&#93; Specifies a put integration request's HTTP method.
         */
        var httpMethod: kotlin.String? = null
        /**
         * Specifies a put integration HTTP method. When the integration type is HTTP or AWS, this field is required.
         */
        var integrationHttpMethod: kotlin.String? = null
        /**
         * Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the `requestTemplates` property on the Integration resource. There are three valid values: `WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, and `NEVER`.
         * + `WHEN_NO_MATCH` passes the request body for unmapped content types through to the integration back end without transformation.
         * + `NEVER` rejects unmapped content types with an HTTP 415 'Unsupported Media Type' response.
         * + `WHEN_NO_TEMPLATES` allows pass-through when the integration has NO content types mapped to templates. However if there is at least one content type defined, unmapped content types will be rejected with the same 415 response.
         */
        var passthroughBehavior: kotlin.String? = null
        /**
         * A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of `method.request.{location}.{name}`, where `location` is `querystring`, `path`, or `header` and `name` must be a valid and unique method request parameter name.
         */
        var requestParameters: Map<String, String>? = null
        /**
         * Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.
         */
        var requestTemplates: Map<String, String>? = null
        /**
         * &#91;Required&#93; Specifies a put integration request's resource ID.
         */
        var resourceId: kotlin.String? = null
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        var restApiId: kotlin.String? = null
        /**
         * Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.
         */
        var timeoutInMillis: kotlin.Int? = null
        var tlsConfig: aws.sdk.kotlin.services.apigateway.model.TlsConfig? = null
        /**
         * &#91;Required&#93; Specifies a put integration input's type.
         */
        var type: aws.sdk.kotlin.services.apigateway.model.IntegrationType? = null
        /**
         * Specifies Uniform Resource Identifier (URI) of the integration endpoint.
         * +  For `HTTP` or `HTTP_PROXY` integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the [RFC-3986 specification](https://en.wikipedia.org/wiki/Uniform_Resource_Identifier), for either standard integration, where `connectionType` is not `VPC_LINK`, or private integration, where `connectionType` is `VPC_LINK`. For a private HTTP integration, the URI is not used for routing.
         * +  For `AWS` or `AWS_PROXY` integrations, the URI is of the form `arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}`. Here, `{Region}` is the API Gateway region (e.g., `us-east-1`); `{service}` is the name of the integrated AWS service (e.g., `s3`); and `{subdomain}` is a designated subdomain supported by certain AWS service for fast host-name lookup. `action` can be used for an AWS service action-based API, using an `Action={name}&{p1}={v1}&p2={v2}...` query string. The ensuing `{service_api}` refers to a supported action `{name}` plus any required input parameters. Alternatively, `path` can be used for an AWS service path-based API. The ensuing `service_api` refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of `<a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a>`, the `uri` can be either `arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}` or `arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}`
         */
        var uri: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.PutIntegrationRequest) : this() {
            this.cacheKeyParameters = x.cacheKeyParameters
            this.cacheNamespace = x.cacheNamespace
            this.connectionId = x.connectionId
            this.connectionType = x.connectionType
            this.contentHandling = x.contentHandling
            this.credentials = x.credentials
            this.httpMethod = x.httpMethod
            this.integrationHttpMethod = x.integrationHttpMethod
            this.passthroughBehavior = x.passthroughBehavior
            this.requestParameters = x.requestParameters
            this.requestTemplates = x.requestTemplates
            this.resourceId = x.resourceId
            this.restApiId = x.restApiId
            this.timeoutInMillis = x.timeoutInMillis
            this.tlsConfig = x.tlsConfig
            this.type = x.type
            this.uri = x.uri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.PutIntegrationRequest = PutIntegrationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.TlsConfig] inside the given [block]
         */
        fun tlsConfig(block: aws.sdk.kotlin.services.apigateway.model.TlsConfig.Builder.() -> kotlin.Unit) {
            this.tlsConfig = aws.sdk.kotlin.services.apigateway.model.TlsConfig.invoke(block)
        }
    }
}
